/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.education.acrennes.ged.dafpic.automation;

import fr.gouv.education.acrennes.ged.dafpic.freemarker.AcarenDafpicFunctions;
import fr.toutatice.ecm.platform.core.helper.ToutaticeSilentProcessRunnerHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.rendering.FreemarkerRender;
import org.nuxeo.ecm.automation.core.scripting.Functions;
import org.nuxeo.ecm.automation.core.scripting.Scripting;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.impl.blob.FileBlob;
import org.nuxeo.runtime.services.resource.ResourceService;

@Operation(id="Services.ExportGREF", category="Services", label="Export GREF", description="Genere un fichier d'export pour le GREF")
public class ExportToGREF {
    public static final String ID = "Services.ExportGREF";
    private static final Log log = LogFactory.getLog(ExportToGREF.class);
    @Context
    protected ResourceService rs;
    @Context
    protected OperationContext ctx;
    @Param(name="template", widget="TemplateResource")
    protected String template;
    @Param(name="file name", required=false, values={"export.xml"})
    protected String name = "export.xml";
    @Param(name="mime type", required=false, values={"text/xml"})
    protected String mimetype = "text/xml";

    @OperationMethod
    public Blob run(DocumentModel doc) throws Exception {
        AcarenDafpicExportRunner runner = new AcarenDafpicExportRunner(this.ctx, doc);
        runner.runUnrestricted();
        return runner.getBlob();
    }

    private Map<String, Object> buildObjectsStructure(CoreSession session, DocumentModel document) {
        Map objStrct = Scripting.initBindings((OperationContext)this.ctx);
        try {
            Catalogue catalogueContacts = new Catalogue(session, document, "ContactAgence");
            Catalogue catalogueFormations = new Catalogue(session, document, "Formation");
            Catalogue catalogueAgences = new Catalogue(session, document, "Agence");
            Catalogue catalogueGreta = new Catalogue(session, document, "Greta");
            CatalogueStages catalogueStages = new CatalogueStages(session, document, catalogueAgences, catalogueGreta);
            objStrct.put("catalogueStages", catalogueStages.get());
            objStrct.put("catalogueContacts", catalogueContacts.get());
            objStrct.put("catalogueFormations", catalogueFormations.get());
        }
        catch (ClientException e) {
            log.error((Object)("Failed to generate the GREF XML export file, error: " + e.getMessage()));
        }
        return objStrct;
    }

    private class CatalogueStages {
        List<Map<String, DocumentModel>> catalogue = new ArrayList<Map<String, DocumentModel>>();

        public CatalogueStages(CoreSession session, DocumentModel document, Catalogue agences, Catalogue gretas) throws ClientException {
            DocumentModelList stages = session.query("SELECT * FROM Stage WHERE ecm:path STARTSWITH '" + document.getPathAsString() + "' AND ecm:mixinType != 'HiddenInNavigation' AND ecm:isCheckedInVersion = 0 AND ecm:currentLifeCycleState != 'deleted'AND stage:lifeCycle = 'EnLigne'", null, -1);
            for (DocumentModel stage : stages) {
                HashMap<String, DocumentModel> stageItem = new HashMap<String, DocumentModel>();
                DocumentRef stageFolderRef = stage.getParentRef();
                DocumentRef agenceRef = session.getDocument(stageFolderRef).getParentRef();
                DocumentModel agence = agences.get(agenceRef.toString());
                DocumentRef gretaRef = agence.getParentRef();
                DocumentModel greta = gretas.get(gretaRef.toString());
                stageItem.put("Stage", stage);
                stageItem.put("Agence", agence);
                if (null != greta) {
                    stageItem.put("Greta", greta);
                }
                this.catalogue.add(stageItem);
            }
        }

        public List<Map<String, DocumentModel>> get() {
            return this.catalogue;
        }
    }

    private class Catalogue {
        Map<String, DocumentModel> catalogue = new HashMap<String, DocumentModel>();

        public Catalogue(CoreSession session, DocumentModel document, String type) throws ClientException {
            DocumentModelList items = session.query("SELECT * FROM " + type + " WHERE ecm:path STARTSWITH '" + document.getPathAsString() + "' AND ecm:mixinType != 'HiddenInNavigation' AND ecm:isCheckedInVersion = 0 AND ecm:currentLifeCycleState != 'deleted'");
            for (DocumentModel item : items) {
                this.catalogue.put(item.getRef().toString(), item);
            }
        }

        public Map<String, DocumentModel> get() {
            return this.catalogue;
        }

        public DocumentModel get(String reference) {
            return this.catalogue.get(reference);
        }
    }

    private class AcarenDafpicExportRunner
    extends ToutaticeSilentProcessRunnerHelper {
        private DocumentModel root;
        private Blob blob;

        public AcarenDafpicExportRunner(OperationContext ctx, DocumentModel root) {
            super(ctx.getCoreSession());
            this.root = root;
            this.blob = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() throws ClientException {
            FreemarkerRender ftl = new FreemarkerRender();
            AcarenDafpicFunctions localFn = null;
            Object currentFninstance = null;
            try {
                currentFninstance = Functions.getInstance();
                localFn = new AcarenDafpicFunctions();
                Functions.setInstance((Object)((Object)localFn));
                Map map = ExportToGREF.this.buildObjectsStructure(this.session, this.root);
                File tempFile = File.createTempFile("GREF-export-", ".tmp");
                FileWriter writer = new FileWriter(tempFile);
                ftl.render(ExportToGREF.this.template, (Object)map, (Writer)writer);
                writer.flush();
                this.blob = new FileBlob((InputStream)new FileInputStream(tempFile), ExportToGREF.this.mimetype);
                this.blob.setFilename(ExportToGREF.this.name);
                tempFile.delete();
            }
            catch (Exception e) {
                log.error((Object)("Failed to render the template '" + ExportToGREF.this.template + "', error: " + e.getMessage()));
            }
            finally {
                if (null != localFn) {
                    localFn.uninstall();
                }
                Functions.setInstance((Object)currentFninstance);
            }
        }

        public Blob getBlob() {
            return this.blob;
        }
    }
}

