/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.education.acrennes.ged.dafpic.core.listener;

import fr.toutatice.ecm.platform.core.helper.ToutaticeDirectoryMngtHelper;
import java.io.Serializable;
import java.util.Locale;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventContext;
import org.nuxeo.ecm.core.event.EventListener;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;

public class CreateStageDocumentListener
implements EventListener {
    public static final Log log = LogFactory.getLog(CreateStageDocumentListener.class);
    private static final String CST_UNKNOWN_TRAINING_REF = "Formation non renseign\u00e9e";
    private static final String CONTACT_QUERY = "select * from ContactAgence where ttc:webid = '%s'";
    private static final String TRAINING_QUERY = "select * from Formation where ttc:webid = '%s' AND ecm:isProxy = 0 AND ecm:isVersion = 0 AND ecm:currentLifeCycleState != 'deleted'";

    public void handleEvent(Event event) throws ClientException {
        String domainesKeys = null;
        DocumentModel training = null;
        EventContext ctx = event.getContext();
        CoreSession session = ctx.getCoreSession();
        try {
            DocumentEventContext docEventContext;
            DocumentModel doc;
            if (ctx instanceof DocumentEventContext && "Stage".equals((doc = (docEventContext = (DocumentEventContext)ctx).getSourceDocument()).getType()) && !doc.isImmutable()) {
                String lifeCycle;
                String refContacts;
                String newRefContacts;
                String refFormation = (String)((Object)doc.getPropertyValue("stage:refFormation"));
                if (StringUtils.isNotBlank((String)refFormation) && null != (training = this.getTraining(session, refFormation))) {
                    String formationWebId = (String)((Object)training.getPropertyValue("ttc:webid"));
                    doc.setPropertyValue("stage:refFormation", (Serializable)((Object)formationWebId));
                }
                if (StringUtils.isNotEmpty((String)(newRefContacts = this.convertFromUids(session, refContacts = (String)((Object)doc.getPropertyValue("stage:refContacts")))))) {
                    doc.setPropertyValue("stage:refContacts", (Serializable)((Object)newRefContacts));
                }
                String title = CST_UNKNOWN_TRAINING_REF;
                if (null != training) {
                    title = training.getTitle();
                }
                doc.setPropertyValue("dc:title", (Serializable)((Object)title));
                if (StringUtils.isNotBlank(domainesKeys)) {
                    String domainesLabels = ToutaticeDirectoryMngtHelper.instance().getDirectoryEntriesLocalizedLabel(new String[]{"FormationDomaines", "FormationSpecialites", "FormationSousSpecialites"}, domainesKeys, Locale.FRENCH);
                    doc.setPropertyValue("stage:fulltextData", (Serializable)((Object)domainesLabels));
                }
                if (StringUtils.isNotBlank((String)(lifeCycle = (String)((Object)doc.getPropertyValue("stage:lifeCycle"))))) {
                    String lcp = doc.getCurrentLifeCycleState();
                    if (!lcp.equals(lifeCycle)) {
                        if ("EnLigne".equals(lifeCycle)) {
                            doc.followTransition("setOnLine");
                        } else {
                            doc.followTransition("setOffLine");
                        }
                    }
                } else {
                    doc.setPropertyValue("stage:lifeCycle", (Serializable)((Object)"HorsLigne"));
                }
                if (!event.getName().equals("beforeDocumentModification")) {
                    session.saveDocument(doc);
                }
            }
        }
        catch (Exception e) {
            throw new ClientException((Throwable)e);
        }
    }

    private String convertFromUids(CoreSession session, String refContacts) {
        Object[] splitContatcsIds;
        StringBuffer result = new StringBuffer();
        if (StringUtils.isNotBlank((String)refContacts) && !ArrayUtils.isEmpty((Object[])(splitContatcsIds = StringUtils.split((String)refContacts, (String)";")))) {
            for (Object contactId : splitContatcsIds) {
                DocumentModel contact;
                block4: {
                    contact = null;
                    if (!StringUtils.isNotBlank((String)contactId)) continue;
                    try {
                        contact = session.getDocument((DocumentRef)new IdRef((String)contactId));
                    }
                    catch (Exception e) {
                        String query = String.format(CONTACT_QUERY, contactId);
                        DocumentModelList contacts = session.query(query);
                        if (contacts == null || contacts.size() != 1) break block4;
                        contact = (DocumentModel)contacts.get(0);
                    }
                }
                if (contact == null) continue;
                String contactUid = (String)((Object)contact.getPropertyValue("ttc:webid"));
                result.append(contactUid).append(";");
            }
        }
        return result.toString();
    }

    private DocumentModel getTraining(CoreSession session, String refFormation) {
        DocumentModel training = null;
        if (StringUtils.isNotBlank((String)refFormation)) {
            try {
                training = session.getDocument((DocumentRef)new IdRef(refFormation));
            }
            catch (Exception e) {
                String query = String.format(TRAINING_QUERY, refFormation);
                DocumentModelList trainings = session.query(query);
                if (trainings != null && trainings.size() == 1) {
                    training = (DocumentModel)trainings.get(0);
                }
                log.error((Object)("No formation with key: " + refFormation));
            }
        }
        return training;
    }
}

