/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.education.acrennes.ged.dafpic.core.listener;

import java.io.Serializable;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventContext;
import org.nuxeo.ecm.core.event.EventListener;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;

public class CreateTrainingDocumentListener
implements EventListener {
    public static final Log log = LogFactory.getLog(CreateTrainingDocumentListener.class);

    public void handleEvent(Event event) throws ClientException {
        EventContext ctx = event.getContext();
        CoreSession session = ctx.getCoreSession();
        try {
            DocumentEventContext docEventContext;
            DocumentModel doc;
            if (ctx instanceof DocumentEventContext && "Formation".equals((doc = (docEventContext = (DocumentEventContext)ctx).getSourceDocument()).getType()) && !doc.isImmutable()) {
                String uid = "";
                String domaines = (String)((Object)doc.getPropertyValue("formation:domaine"));
                if (StringUtils.isNotBlank((String)domaines)) {
                    String[] domainesList = domaines.split("/");
                    if (2 < domainesList.length) {
                        String sspec = domainesList[2];
                        String sspecId = sspec.substring(sspec.length() - 1);
                        uid = domainesList[0] + domainesList[1] + sspecId;
                    } else {
                        uid = domaines.replaceAll("/", "");
                    }
                }
                if (uid.trim().isEmpty() && log.isWarnEnabled()) {
                    log.warn((Object)"The metadata 'formation:domaine' should at least be defined with one level category");
                }
                uid = StringUtils.rightPad((String)uid, (int)7, (char)'0');
                String query = "SELECT * FROM Formation WHERE formation:uid LIKE '" + uid + "%'";
                DocumentModelList result = session.query(query);
                long count = result.size();
                uid = uid + String.format("%03d", count + 1L);
                doc.setPropertyValue("formation:uid", (Serializable)((Object)uid));
                if (!event.getName().equals("beforeDocumentModification")) {
                    session.saveDocument(doc);
                }
            }
        }
        catch (Exception e) {
            throw new ClientException((Throwable)e);
        }
    }
}

