/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.education.acrennes.ged.dafpic.services;

import fr.toutatice.ecm.platform.core.helper.ToutaticeQueryHelper;
import java.util.Collection;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.common.utils.IdUtils;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.platform.uidgen.AbstractUIDGenerator;

public class WebIdsGenerator
extends AbstractUIDGenerator {
    private static final String NFORMAT = "%04d";

    public String getSequenceKey(DocumentModel document) throws DocumentException {
        assert (document != null);
        String title = "";
        if ("ContactAgence".equals(document.getType())) {
            String firstName = (String)((Object)document.getPropertyValue("contactagence:firstName"));
            String lastName = (String)((Object)document.getPropertyValue("contactagence:lastName"));
            title = IdUtils.generateId((String)firstName, (String)"-", (boolean)true, (int)3) + IdUtils.generateId((String)lastName, (String)"-", (boolean)true, (int)3);
        } else {
            title = document.getTitle();
            title = StringUtils.isNotBlank((String)title) ? IdUtils.generateId((String)title, (String)"-", (boolean)true, (int)7) : "-";
        }
        return StringUtils.lowerCase((String)new StringBuffer().append(document.getType()).append("-").append(title).toString());
    }

    public String createUID(DocumentModel document) throws DocumentException {
        String query;
        String webId = (String)((Object)document.getPropertyValue("ttc:webid"));
        CoreSession session = document.getCoreSession();
        DocumentModelList docs = ToutaticeQueryHelper.queryUnrestricted((CoreSession)session, (String)String.format(query = "select * from Document where ttc:webid = '%s'", webId));
        if (CollectionUtils.isEmpty((Collection)docs)) {
            if (StringUtils.isBlank((String)webId)) {
                webId = this.generateUID(document);
            }
        } else if (CollectionUtils.isNotEmpty((Collection)docs) && docs.size() == 1) {
            webId = this.generateUID(document);
        } else {
            throw new DocumentException("More than one document with webId: " + webId);
        }
        return webId;
    }

    private String generateUID(DocumentModel document) throws DocumentException {
        int index = this.getNext(document);
        String n = String.format(NFORMAT, index);
        String seqKey = this.getSequenceKey(document);
        return new StringBuffer().append(seqKey).append("-").append(n).toString();
    }
}

