/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.client.runtime;

import java.util.Map;
import org.apache.chemistry.opencmis.client.bindings.CmisBindingFactory;
import org.apache.chemistry.opencmis.client.bindings.cache.TypeDefinitionCache;
import org.apache.chemistry.opencmis.commons.enums.BindingType;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.spi.AuthenticationProvider;
import org.apache.chemistry.opencmis.commons.spi.CmisBinding;

public final class CmisBindingHelper {
    private CmisBindingHelper() {
    }

    public static CmisBinding createBinding(Map<String, String> parameters, AuthenticationProvider authenticationProvider, TypeDefinitionCache typeDefCache) {
        if (parameters == null || parameters.isEmpty()) {
            throw new CmisRuntimeException("Session parameter not set!");
        }
        if (!parameters.containsKey("org.apache.chemistry.opencmis.binding.spi.type")) {
            parameters.put("org.apache.chemistry.opencmis.binding.spi.type", BindingType.CUSTOM.value());
        }
        BindingType bt = BindingType.fromValue((String)parameters.get("org.apache.chemistry.opencmis.binding.spi.type"));
        switch (bt) {
            case ATOMPUB: {
                return CmisBindingHelper.createAtomPubBinding(parameters, authenticationProvider, typeDefCache);
            }
            case WEBSERVICES: {
                return CmisBindingHelper.createWebServiceBinding(parameters, authenticationProvider, typeDefCache);
            }
            case BROWSER: {
                return CmisBindingHelper.createCmisBrowserBinding(parameters, authenticationProvider, typeDefCache);
            }
            case LOCAL: {
                return CmisBindingHelper.createLocalBinding(parameters, typeDefCache);
            }
            case CUSTOM: {
                return CmisBindingHelper.createCustomBinding(parameters, authenticationProvider, typeDefCache);
            }
        }
        throw new CmisRuntimeException("Ambiguous session parameter: " + parameters);
    }

    private static CmisBinding createCustomBinding(Map<String, String> parameters, AuthenticationProvider authenticationProvider, TypeDefinitionCache typeDefCache) {
        CmisBindingFactory factory = CmisBindingFactory.newInstance();
        CmisBinding binding = factory.createCmisBinding(parameters, authenticationProvider, typeDefCache);
        return binding;
    }

    private static CmisBinding createWebServiceBinding(Map<String, String> parameters, AuthenticationProvider authenticationProvider, TypeDefinitionCache typeDefCache) {
        CmisBindingFactory factory = CmisBindingFactory.newInstance();
        CmisBinding binding = factory.createCmisWebServicesBinding(parameters, authenticationProvider, typeDefCache);
        return binding;
    }

    private static CmisBinding createAtomPubBinding(Map<String, String> parameters, AuthenticationProvider authenticationProvider, TypeDefinitionCache typeDefCache) {
        CmisBindingFactory factory = CmisBindingFactory.newInstance();
        CmisBinding binding = factory.createCmisAtomPubBinding(parameters, authenticationProvider, typeDefCache);
        return binding;
    }

    private static CmisBinding createCmisBrowserBinding(Map<String, String> parameters, AuthenticationProvider authenticationProvider, TypeDefinitionCache typeDefCache) {
        CmisBindingFactory factory = CmisBindingFactory.newInstance();
        CmisBinding binding = factory.createCmisBrowserBinding(parameters, authenticationProvider, typeDefCache);
        return binding;
    }

    private static CmisBinding createLocalBinding(Map<String, String> parameters, TypeDefinitionCache typeDefCache) {
        CmisBindingFactory factory = CmisBindingFactory.newInstance();
        CmisBinding binding = factory.createCmisLocalBinding(parameters, typeDefCache);
        return binding;
    }
}

