/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.core.helper;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.runtime.api.Framework;

public class ToutaticeUserMngtHelper {
    private static final Log log = LogFactory.getLog(ToutaticeUserMngtHelper.class);
    private static ToutaticeUserMngtHelper instance;
    private static UserManager userManager;

    private ToutaticeUserMngtHelper() {
    }

    public static ToutaticeUserMngtHelper instance() {
        if (null == instance) {
            instance = new ToutaticeUserMngtHelper();
        }
        return instance;
    }

    public String getCurrentUserFullName(String principalName) {
        String fullName = principalName;
        String firstName = this.getUserProperty(principalName, "user:firstName");
        String lastName = this.getUserProperty(principalName, "user:lastName");
        if (null != firstName && null != lastName) {
            fullName = firstName + " " + lastName;
        }
        return StringUtils.isNotBlank((String)fullName) ? fullName : principalName;
    }

    public String getUserProperty(String principalName, String propertyName) {
        String propertyValue = "";
        try {
            propertyValue = (String)((Object)ToutaticeUserMngtHelper.getUserManager().getUserModel(principalName).getPropertyValue(propertyName));
        }
        catch (Exception e) {
            log.error((Object)("Failed to get the user property '" + propertyName + "' from the user '" + principalName + "', error: " + e.getMessage()));
        }
        return propertyValue;
    }

    public List<String> getPublicUsers() throws ClientException {
        String members;
        ArrayList<String> publicUsers = new ArrayList<String>();
        publicUsers = new ArrayList();
        String anonymous = ToutaticeUserMngtHelper.getUserManager().getAnonymousUserId();
        if (StringUtils.isNotBlank((String)anonymous)) {
            publicUsers.add(anonymous);
        }
        if (StringUtils.isNotBlank((String)(members = ToutaticeUserMngtHelper.getUserManager().getDefaultGroup()))) {
            publicUsers.add(members);
        }
        return publicUsers;
    }

    public List<String> getSuperAdministrators() throws ClientException {
        return ToutaticeUserMngtHelper.getUserManager().getAdministratorsGroups();
    }

    private static UserManager getUserManager() throws ClientException {
        try {
            if (null == userManager) {
                userManager = (UserManager)Framework.getService(UserManager.class);
            }
        }
        catch (Exception e) {
            log.error((Object)("Failed to get the user manager service, exception message: " + e.getMessage()));
            throw new ClientException("Failed to get the user manager service, exception message: " + e.getMessage());
        }
        return userManager;
    }
}

