/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.core.listener;

import fr.toutatice.ecm.platform.core.helper.ToutaticeDocumentHelper;
import java.util.Calendar;
import java.util.Date;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventListener;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.platform.dublincore.NXDublinCore;
import org.nuxeo.ecm.platform.dublincore.service.DublinCoreStorageService;

public class ToutaticeDocumentCopiedListener
implements EventListener {
    public void handleEvent(Event event) throws ClientException {
        if ("documentCreatedByCopy".equals(event.getName()) && event.getContext() instanceof DocumentEventContext) {
            DocumentEventContext docCtx = (DocumentEventContext)event.getContext();
            DublinCoreStorageService service = NXDublinCore.getDublinCoreStorageService();
            Boolean block = (Boolean)docCtx.getProperty("disableDublinCoreListener");
            if (Boolean.TRUE.equals(block)) {
                return;
            }
            DocumentModel document = docCtx.getSourceDocument();
            if (document.hasFacet("SystemDocument")) {
                return;
            }
            Date eventDate = new Date(event.getTime());
            Calendar cEventDate = Calendar.getInstance();
            cEventDate.setTime(eventDate);
            service.setCreationDate(document, cEventDate, event);
            service.setModificationDate(document, cEventDate, event);
            service.addContributor(document, event);
            document = this.setCreator(docCtx, document);
            ToutaticeDocumentHelper.saveDocumentSilently(docCtx.getCoreSession(), document, true);
        }
    }

    protected DocumentModel setCreator(DocumentEventContext docCtx, DocumentModel document) {
        document.setProperty("dublincore", "creator", (Object)docCtx.getPrincipal().getName());
        return document;
    }
}

