/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.core.listener;

import fr.toutatice.ecm.platform.core.helper.ToutaticeDocumentHelper;
import fr.toutatice.ecm.platform.core.helper.ToutaticeDocumentMetadataHelper;
import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventListener;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;

public class ToutaticeUnicityTitleListener
implements EventListener {
    public static final String DEFAULT_COPIED_TITLE_SUFFIX = " (copie)";
    public static final String DEFAULT_TITLE_SUFFIX = " (1)";
    private static final Pattern TITLE_SUFFIX_PATTERN = Pattern.compile("(.*)\\((copie |copie)?([0-9]+)?\\)(\\.[a-z]+)?$");

    public void handleEvent(Event event) throws ClientException {
        if (event.getContext() instanceof DocumentEventContext) {
            DocumentEventContext docCtx = (DocumentEventContext)event.getContext();
            DocumentModel document = docCtx.getSourceDocument();
            if (ToutaticeDocumentHelper.isInWorkSpace(docCtx.getCoreSession(), document)) {
                document = this.checksUnicityTitle(docCtx, event.getName(), document);
                ToutaticeDocumentHelper.saveDocumentSilently(docCtx.getCoreSession(), document, true);
            }
        }
    }

    protected DocumentModel checksUnicityTitle(DocumentEventContext docCtx, String eventName, DocumentModel document) {
        CoreSession session = docCtx.getCoreSession();
        String parentUUId = session.getParentDocument(document.getRef()).getId();
        String docUUId = document.getId();
        String title = (String)((Object)document.getPropertyValue("dc:title"));
        boolean isUniqueTitle = ToutaticeDocumentMetadataHelper.isTileUnique(session, parentUUId, docUUId, title);
        while (!isUniqueTitle) {
            Matcher matcher = TITLE_SUFFIX_PATTERN.matcher(title);
            if (matcher.find()) {
                StringBuffer sb = new StringBuffer();
                String number = matcher.group(3);
                if (number != null) {
                    int num = Integer.valueOf(number) + 1;
                    number = String.valueOf(num);
                } else {
                    number = " " + String.valueOf(1);
                }
                matcher.appendReplacement(sb, "$1($2" + number + ")$4");
                title = matcher.appendTail(sb).toString();
            } else {
                String fileExtension = StringUtils.substringAfterLast((String)title, (String)".");
                if (StringUtils.isNotEmpty((String)fileExtension)) {
                    fileExtension = ".".concat(fileExtension);
                }
                String marker = DEFAULT_TITLE_SUFFIX;
                if ("documentCreatedByCopy".equals(eventName)) {
                    marker = DEFAULT_COPIED_TITLE_SUFFIX;
                }
                title = StringUtils.removeEnd((String)title, (String)fileExtension).concat(marker).concat(fileExtension);
            }
            isUniqueTitle = ToutaticeDocumentMetadataHelper.isTileUnique(session, parentUUId, docUUId, title);
        }
        document.setPropertyValue("dc:title", (Serializable)((Object)title));
        return document;
    }
}

