/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.core.security;

import fr.toutatice.ecm.platform.core.security.OwnerSecurityPolicyHelper;
import java.security.Principal;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.plexus.util.StringUtils;
import org.nuxeo.common.utils.ArrayUtils;
import org.nuxeo.ecm.core.api.DocumentException;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.core.api.security.Access;
import org.nuxeo.ecm.core.model.Document;
import org.nuxeo.ecm.core.query.sql.model.SQLQuery;
import org.nuxeo.ecm.core.security.AbstractSecurityPolicy;

public class ToutaticeOwnerSecurityPolicy
extends AbstractSecurityPolicy {
    private static final Log log = LogFactory.getLog(ToutaticeOwnerSecurityPolicy.class);
    private static final String[] DOCUMENT_PERMISSIONS = new String[]{"Read", "Write", "validationWorkflow_validation"};
    private static final String[] PARENT_PERMISSIONS = new String[]{"Read", "RemoveChildren", "validationWorkflow_validation"};
    private static final String[] FOLDERISH_PERMISSIONS = new String[]{"AddChildren", "validationWorkflow_validation"};

    protected String[] getDocumentPermissions() {
        return DOCUMENT_PERMISSIONS;
    }

    protected String[] getParentPermissions() {
        return PARENT_PERMISSIONS;
    }

    protected String[] getFolderishPermissions() {
        return FOLDERISH_PERMISSIONS;
    }

    public Access checkPermission(Document doc, ACP mergedAcp, Principal principal, String permission, String[] resolvedPermissions, String[] additionalPrincipals) {
        Access access = Access.UNKNOWN;
        String[] ownerPermissions = (String[])org.apache.commons.lang.ArrayUtils.add((Object[])OwnerSecurityPolicyHelper.getAliases(), (Object)"WriteModifyOwnOnly");
        try {
            if (this.doPolicyApply(ownerPermissions, mergedAcp, principal, additionalPrincipals)) {
                access = doc.isFolder() ? this.applyPolicyToFolderish(doc, principal, permission) : this.applyPolicyToLeaf(doc, principal, resolvedPermissions);
            }
        }
        catch (DocumentException e) {
            log.error((Object)("Failed to evaluate the policy, error: " + e.getMessage()));
        }
        return access;
    }

    private boolean doPolicyApply(String[] ownerPermissions, ACP mergedAcp, Principal principal, String[] additionalPrincipals) {
        boolean hasAllPermissions;
        if (!org.apache.commons.lang.ArrayUtils.contains((Object[])additionalPrincipals, (Object)principal.getName())) {
            additionalPrincipals[additionalPrincipals.length] = principal.getName();
        }
        return !(hasAllPermissions = Access.GRANT.equals(mergedAcp.getAccess(additionalPrincipals, new String[]{"Everything"}))) && Access.GRANT.equals(mergedAcp.getAccess(additionalPrincipals, ownerPermissions));
    }

    protected Access applyPolicyToFolderish(Document doc, Principal principal, String permission) throws DocumentException {
        if (org.apache.commons.lang.ArrayUtils.contains((Object[])this.getFolderishPermissions(), (Object)permission) || org.apache.commons.lang.ArrayUtils.contains((Object[])this.getParentPermissions(), (Object)permission)) {
            return Access.GRANT;
        }
        return Access.UNKNOWN;
    }

    protected Access applyPolicyToLeaf(Document doc, Principal principal, String[] resolvedPermissions) throws DocumentException {
        Object[] allowedPerms;
        if (this.isCreator(doc, principal) && org.apache.commons.lang.ArrayUtils.isNotEmpty((Object[])(allowedPerms = (String[])ArrayUtils.intersect((Object[][])new String[][]{this.getDocumentPermissions(), resolvedPermissions})))) {
            return Access.GRANT;
        }
        return Access.UNKNOWN;
    }

    protected boolean isCreator(Document doc, Principal principal) throws DocumentException {
        String creator = (String)((Object)doc.getPropertyValue("dc:creator"));
        return StringUtils.equals((String)principal.getName(), (String)creator);
    }

    public boolean isRestrictingPermission(String permission) {
        assert (permission.equals("Browse"));
        return false;
    }

    public boolean isExpressibleInQuery() {
        return true;
    }

    public SQLQuery.Transformer getQueryTransformer() {
        return SQLQuery.Transformer.IDENTITY;
    }
}

