/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.service.editablewindows;

import fr.toutatice.ecm.platform.service.editablewindows.EditableWindowService;
import fr.toutatice.ecm.platform.service.editablewindows.EwDescriptor;
import fr.toutatice.ecm.platform.service.editablewindows.EwServiceException;
import fr.toutatice.ecm.platform.service.editablewindows.types.AbstractEditableWindow;
import fr.toutatice.ecm.platform.service.editablewindows.types.EditableWindow;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

public class EditableWindowServiceImpl
extends DefaultComponent
implements EditableWindowService {
    private static final Log log = LogFactory.getLog(EditableWindowServiceImpl.class);
    private static final Map<EwDescriptor, EditableWindow> ewMap = new HashMap<EwDescriptor, EditableWindow>();
    public static String SCHEMA = "fragments";

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) throws Exception {
        EwDescriptor contribDescriptor = (EwDescriptor)contribution;
        contribDescriptor.initFragment();
        this.addEwType(contribDescriptor);
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) throws Exception {
        EwDescriptor contribDescriptor = (EwDescriptor)contribution;
        this.removeEwType(contribDescriptor);
    }

    private void addEwType(EwDescriptor contribution) {
        if (ewMap.get(contribution) == null) {
            ewMap.put(contribution, contribution.getInstance());
        } else {
            log.warn((Object)("Contribution " + contribution.code + " has already been registered."));
        }
    }

    private void removeEwType(EwDescriptor contribution) {
        ewMap.remove(contribution);
    }

    @Override
    public Map.Entry<EwDescriptor, EditableWindow> findByCode(String code) throws EwServiceException {
        for (Map.Entry<EwDescriptor, EditableWindow> entry : ewMap.entrySet()) {
            if (!entry.getKey().getCode().equals(code)) continue;
            return entry;
        }
        throw new EwServiceException("osivia.error.fragment_not_found");
    }

    @Override
    public Map.Entry<EwDescriptor, EditableWindow> getEwEntry(DocumentModel doc, String uri) throws EwServiceException {
        String category;
        block4: {
            category = null;
            try {
                Map properties = doc.getProperties(SCHEMA);
                Collection values = properties.values();
                Object liste = values.iterator().next();
                if (!(liste instanceof List)) break block4;
                List listeEw = (List)liste;
                for (Map ew : listeEw) {
                    if (!uri.equals(ew.get("uri"))) continue;
                    category = ew.get("fragmentCategory").toString();
                    break;
                }
            }
            catch (ClientException e) {
                throw new EwServiceException((Exception)((Object)e));
            }
        }
        if (category == null) {
            throw new EwServiceException("osivia.error.fragment_not_found");
        }
        Map.Entry<EwDescriptor, EditableWindow> findByCode = this.findByCode(category);
        return findByCode;
    }

    @Override
    public String prepareCreation(DocumentModel doc, EditableWindow specific, String category, String region, String belowUri, String code2) throws EwServiceException {
        String uri = null;
        try {
            Map properties = doc.getProperties(SCHEMA);
            Collection values = properties.values();
            Object liste = values.iterator().next();
            if (liste instanceof List) {
                List listeEw = (List)liste;
                uri = Long.toString(new Date().getTime());
                String regionId = region;
                Integer order = new Integer(0);
                if (belowUri != null) {
                    for (Map window : listeEw) {
                        if (!belowUri.equals(window.get("uri"))) continue;
                        regionId = window.get("regionId").toString();
                        String orderStr = window.get("order").toString();
                        order = Integer.parseInt(orderStr) + 1;
                        break;
                    }
                }
                for (Map window : listeEw) {
                    String regionCompare = window.get("regionId").toString();
                    String orderCompare = window.get("order").toString();
                    if (!regionId.equals(regionCompare) || Integer.parseInt(orderCompare) < order) continue;
                    Integer newOrder = Integer.parseInt(orderCompare) + 1;
                    window.put("order", newOrder.toString());
                }
                HashMap<String, String> newEntry = new HashMap<String, String>();
                newEntry.put("fragmentCategory", category);
                newEntry.put("order", order.toString());
                newEntry.put("regionId", regionId);
                newEntry.put("uri", uri);
                newEntry.put("title", "Nouveau fragment");
                newEntry.put("hideTitle", Boolean.FALSE.toString());
                newEntry.put("collapsed", Boolean.FALSE.toString());
                newEntry.put("style", "");
                listeEw.add(newEntry);
                doc.setProperties(SCHEMA, properties);
            }
        }
        catch (ClientException e) {
            throw new EwServiceException((Exception)((Object)e));
        }
        specific.prepareCreation(doc, uri, region, belowUri, code2);
        return uri;
    }

    @Override
    public String duplicate(DocumentModel doc, String fromUri) throws EwServiceException {
        String newUri = null;
        Map.Entry<EwDescriptor, EditableWindow> ew = this.getEwEntry(doc, fromUri);
        try {
            Map properties = doc.getProperties(SCHEMA);
            Collection values = properties.values();
            Object liste = values.iterator().next();
            String regionId = "";
            Object specific = null;
            if (liste instanceof List) {
                List listeEw = (List)liste;
                newUri = Long.toString(new Date().getTime());
                Integer order = new Integer(0);
                for (Map window : listeEw) {
                    if (!fromUri.equals(window.get("uri"))) continue;
                    String orderStr = window.get("order").toString();
                    order = Integer.parseInt(orderStr) + 1;
                    regionId = window.get("regionId").toString();
                    HashMap<String, String> newEntry = new HashMap<String, String>();
                    newEntry.putAll(window);
                    newEntry.put("order", order.toString());
                    newEntry.put("uri", newUri);
                    listeEw.add(newEntry);
                    break;
                }
                for (Map window : listeEw) {
                    String regionCompare = window.get("regionId").toString();
                    String orderCompare = window.get("order").toString();
                    if (!regionId.equals(regionCompare) || Integer.parseInt(orderCompare) < order) continue;
                    Integer newOrder = Integer.parseInt(orderCompare) + 1;
                    window.put("order", newOrder.toString());
                }
                doc.setProperties(SCHEMA, properties);
                EditableWindow value = ew.getValue();
                if (value instanceof AbstractEditableWindow) {
                    AbstractEditableWindow aew = (AbstractEditableWindow)value;
                    aew.duplicate(doc, fromUri, newUri);
                }
            }
        }
        catch (ClientException e) {
            throw new EwServiceException((Exception)((Object)e));
        }
        return newUri;
    }
}

