/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.service.fragments.helpers;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;

@Name(value="setListBeanHelper")
@Scope(value=ScopeType.SESSION)
@Install(precedence=31)
public class SetListBeanHelper
implements Serializable {
    private static final long serialVersionUID = -4012062396374104983L;
    private static final String schemaName = "set_fragments";
    private static final String setXpath = "setfgt:setFragment";
    private static final String setName = "setName";
    private static final String setWebId = "setWebId";
    protected String pageWebId;
    protected String pageTitle;
    @In(create=true)
    protected NavigationContext navigationContext;

    public void addItem(int index) {
        if (this.getPageWebId() != null) {
            DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
            Map setProperties = currentDocument.getProperties(schemaName);
            List listFgt = (List)setProperties.get(setXpath);
            Map currentSetFgt = (Map)listFgt.get(index);
            List listSetItems = (List)currentSetFgt.get("setItems");
            HashMap<String, String> newSetItems = new HashMap<String, String>(2);
            newSetItems.put(setName, this.getPageTitle());
            String pageWebIdCleared = this.getPageWebId().substring(11);
            newSetItems.put(setWebId, pageWebIdCleared);
            listSetItems.add(newSetItems);
            currentDocument.setProperties(schemaName, setProperties);
        }
    }

    public void removeItem(int index, int setIndex) {
        DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
        Map setProperties = currentDocument.getProperties(schemaName);
        List listFgt = (List)setProperties.get(setXpath);
        Map currentSetFgt = (Map)listFgt.get(index);
        List listSetItems = (List)currentSetFgt.get("setItems");
        listSetItems.remove(setIndex);
        currentDocument.setProperties(schemaName, setProperties);
    }

    public void moveItem(int index, int previousPosition, int newPosition) {
        DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
        Map setProperties = currentDocument.getProperties(schemaName);
        List listFgt = (List)setProperties.get(setXpath);
        Map currentSetFgt = (Map)listFgt.get(index);
        List listSetItems = (List)currentSetFgt.get("setItems");
        listSetItems.add(newPosition, listSetItems.remove(previousPosition));
        currentDocument.setProperties(schemaName, setProperties);
    }

    public String getPageWebId() {
        return this.pageWebId;
    }

    public void setPageWebId(String pageWebId) {
        this.pageWebId = pageWebId;
    }

    public String getPageTitle() {
        return this.pageTitle;
    }

    public void setPageTitle(String pageTitle) {
        this.pageTitle = pageTitle;
    }
}

