/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.web.fragments;

import fr.toutatice.ecm.platform.service.editablewindows.EditableWindowService;
import fr.toutatice.ecm.platform.service.editablewindows.EwDescriptor;
import fr.toutatice.ecm.platform.service.editablewindows.EwServiceException;
import fr.toutatice.ecm.platform.service.editablewindows.types.EditableWindow;
import fr.toutatice.ecm.platform.service.url.ToutaticeDocumentResolver;
import fr.toutatice.ecm.platform.service.url.WebIdRef;
import fr.toutatice.ecm.platform.web.fragments.GenericActionBean;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.faces.context.FacesContext;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.web.RequestParameter;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.runtime.api.Framework;

@Name(value="fragmentBean")
@Scope(value=ScopeType.CONVERSATION)
@Install(precedence=30)
public class FragmentActionBean
extends GenericActionBean {
    private static final Log log = LogFactory.getLog(FragmentActionBean.class);
    @In(create=true)
    private CoreSession documentManager;
    @RequestParameter(value="refURI")
    private String requestedRefUri;
    private String uri;
    @RequestParameter(value="region")
    private String requestedRegion;
    private String region;
    @RequestParameter(value="belowURI")
    private String requestedBelowUri;
    private String belowUri;
    private boolean canCancel = false;
    private Map<String, String> listViewsParam = new HashMap<String, String>();
    private EwDescriptor descriptor;
    private EditableWindowService service;
    public static final String NX_PREFIX_PATH = "/nuxeo/nxpath/default";
    public static final String NX_PREFIX_WEBID = "/nuxeo/web/";

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public String getBelowUri() {
        return this.belowUri;
    }

    public void setBelowUri(String belowUri) {
        this.belowUri = belowUri;
    }

    public boolean isCanCancel() {
        return this.canCancel;
    }

    public Map<String, String> getListViewsParam() {
        if (this.listViewsParam.size() == 0) {
            this.listViewsParam.put("directoryName", "list-views");
        }
        return this.listViewsParam;
    }

    public EwDescriptor getDescriptor() {
        if (this.descriptor == null) {
            this.initDescriptor();
        }
        return this.descriptor;
    }

    public String dispatchCreation(String code, String code2) {
        try {
            Map.Entry<EwDescriptor, EditableWindow> fragmentInfos = this.getFragmentService().findByCode(code);
            if (fragmentInfos != null) {
                EditableWindow fragment = fragmentInfos.getValue();
                this.descriptor = fragmentInfos.getKey();
                FacesContext context = FacesContext.getCurrentInstance();
                DocumentModel doc = (DocumentModel)context.getApplication().evaluateExpressionGet(context, "#{currentDocument}", DocumentModel.class);
                if (this.region != null || this.belowUri != null) {
                    this.uri = this.getFragmentService().prepareCreation(doc, fragment, code, this.region, this.belowUri, code2);
                } else {
                    this.addMessage("osivia.error.region_unbound");
                }
            } else {
                this.addMessage("osivia.error.fragment_not_found");
            }
        }
        catch (EwServiceException e) {
            this.addMessage(e.getMessage());
        }
        this.canCancel = true;
        return "osivia_create_fragment_2";
    }

    public String cancelCreation() {
        this.descriptor = null;
        this.uri = null;
        return "osivia_create_fragment";
    }

    private EditableWindowService getFragmentService() {
        if (this.service == null) {
            try {
                this.service = (EditableWindowService)Framework.getService(EditableWindowService.class);
            }
            catch (Exception e) {
                this.addMessage(e.getMessage());
            }
        }
        return this.service;
    }

    public void initDescriptor() {
        try {
            if (this.uri != null) {
                FacesContext context = FacesContext.getCurrentInstance();
                DocumentModel doc = (DocumentModel)context.getApplication().evaluateExpressionGet(context, "#{currentDocument}", DocumentModel.class);
                Map.Entry<EwDescriptor, EditableWindow> fragmentInfos = this.getFragmentService().getEwEntry(doc, this.uri);
                this.descriptor = fragmentInfos.getKey();
            } else {
                this.addMessage("osivia.error.fragment_not_found");
            }
        }
        catch (EwServiceException e) {
            this.addMessage(e.getMessage());
        }
    }

    @Create
    public void startUp() {
        if (this.requestedRefUri != null) {
            this.uri = this.requestedRefUri;
        }
        if (this.requestedBelowUri != null) {
            this.belowUri = this.requestedBelowUri;
        }
        if (this.requestedRegion != null) {
            this.region = this.requestedRegion;
        }
    }

    public String getTitleByPath(String path) {
        String title = path;
        if (StringUtils.startsWith((String)path, (String)NX_PREFIX_PATH)) {
            String shortPath = StringUtils.substringAfter((String)path, (String)NX_PREFIX_PATH);
            PathRef pathRef = new PathRef(shortPath);
            DocumentModel document = this.documentManager.getDocument((DocumentRef)pathRef);
            if (document != null) {
                title = document.getTitle();
                if (StringUtils.isBlank((String)title)) {
                    log.error((Object)("Document with path " + shortPath + " has no tittle"));
                }
            } else {
                log.error((Object)("There is no document with path " + shortPath));
            }
        } else if (StringUtils.startsWith((String)path, (String)NX_PREFIX_WEBID)) {
            String wId = StringUtils.substringAfter((String)path, (String)NX_PREFIX_WEBID);
            WebIdRef idRef = new WebIdRef("", wId, "");
            try {
                DocumentModelList documents = ToutaticeDocumentResolver.resolveReference((CoreSession)this.documentManager, (WebIdRef)idRef);
                if (CollectionUtils.isNotEmpty((Collection)documents) && documents.size() == 1) {
                    title = ((DocumentModel)documents.get(0)).getTitle();
                    if (StringUtils.isBlank((String)title)) {
                        log.error((Object)("Document with id " + wId + " has no tittle"));
                    }
                } else {
                    log.error((Object)("No or more than one document with id: " + wId));
                }
            }
            catch (ClientException | DocumentException e) {
                log.error((Object)e.getMessage());
            }
        }
        return title;
    }
}

