/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.elasticsearch.automation;

import fr.toutatice.ecm.elasticsearch.helper.SQLHelper;
import fr.toutatice.ecm.elasticsearch.query.TTCNxQueryBuilder;
import fr.toutatice.ecm.elasticsearch.search.TTCSearchResponse;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.elasticsearch.action.search.SearchResponse;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.jaxrs.DefaultJsonAdapter;
import org.nuxeo.ecm.automation.jaxrs.JsonAdapter;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.core.schema.types.Schema;
import org.nuxeo.elasticsearch.api.ElasticSearchService;
import org.nuxeo.elasticsearch.query.NxQueryBuilder;

@Operation(id="Document.QueryES", category="Fetch", label="Query via ElasticSerach", description="Perform a query on ElasticSerach instead of Repository")
public class QueryES {
    private static final Log log = LogFactory.getLog(QueryES.class);
    private static final int DEFAULT_MAX_RESULT_SIZE = 10000;
    public static final String ID = "Document.QueryES";
    @Context
    CoreSession session;
    @Context
    ElasticSearchService elasticSearchService;
    @Context
    SchemaManager schemaManager;
    @Param(name="query", required=true)
    protected String query;
    @Param(name="pageSize", required=false)
    protected Integer pageSize;
    @Param(name="currentPageIndex", required=false)
    protected Integer currentPageIndex;
    @Param(name="X-NXDocumentProperties", required=false)
    protected String nxProperties;

    @OperationMethod
    public JsonAdapter run() throws OperationException {
        NxQueryBuilder builder = new TTCNxQueryBuilder(this.session).nxql(SQLHelper.getInstance().escape(this.query));
        if (null != this.currentPageIndex && null != this.pageSize) {
            builder.offset((0 <= this.currentPageIndex ? this.currentPageIndex : 0) * this.pageSize);
            builder.limit(this.pageSize.intValue());
        } else {
            builder.limit(10000);
        }
        this.elasticSearchService.query(builder);
        SearchResponse esResponse = ((TTCNxQueryBuilder)builder).getSearchResponse();
        return new DefaultJsonAdapter((Object)new TTCSearchResponse(esResponse, this.pageSize, this.currentPageIndex, this.getSchemas(this.nxProperties)));
    }

    private List<String> getSchemas(String nxProperties) {
        ArrayList<String> schemas = new ArrayList<String>();
        if (StringUtils.isNotBlank((String)nxProperties)) {
            String[] schemasList;
            for (String schema : schemasList = nxProperties.split(",")) {
                Schema sch = this.schemaManager.getSchema(StringUtils.trim((String)schema));
                if (null != sch) {
                    String prefix = sch.getNamespace().prefix;
                    schemas.add(StringUtils.isNotBlank((String)prefix) ? prefix : sch.getName());
                    continue;
                }
                log.warn((Object)("Unknown schema '" + schema + "' (query='" + this.query + "')"));
            }
        }
        return schemas;
    }
}

