/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.web.context;

import fr.toutatice.ecm.platform.core.constants.ToutaticeGlobalConst;
import fr.toutatice.ecm.platform.core.helper.ToutaticeDocumentHelper;
import fr.toutatice.ecm.platform.service.url.ToutaticeDocumentResolver;
import fr.toutatice.ecm.platform.service.url.WebIdRef;
import fr.toutatice.ecm.platform.service.url.WebIdResolver;
import fr.toutatice.ecm.platform.web.context.ToutaticeNavigationContext;
import fr.toutatice.ecm.platform.web.context.ToutaticeProxyDocumentPathElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Observer;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.faces.FacesMessages;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.ClientRuntimeException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.DocumentSecurityException;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.ecm.core.api.impl.DocumentModelListImpl;
import org.nuxeo.ecm.platform.ui.web.pathelements.ArchivedVersionsPathElement;
import org.nuxeo.ecm.platform.ui.web.pathelements.DocumentPathElement;
import org.nuxeo.ecm.platform.ui.web.pathelements.PathElement;
import org.nuxeo.ecm.platform.ui.web.pathelements.VersionDocumentPathElement;
import org.nuxeo.ecm.webapp.context.NavigationContextBean;

@Name(value="navigationContext")
@Scope(value=ScopeType.CONVERSATION)
@Install(precedence=31)
public class ToutaticeNavigationContextBean
extends NavigationContextBean
implements ToutaticeNavigationContext {
    @In(create=true, required=false)
    protected FacesMessages facesMessages;
    @In(create=true)
    protected Map<String, String> messages;
    private static final long serialVersionUID = -2641552800368018402L;
    private static final Log log = LogFactory.getLog(ToutaticeNavigationContextBean.class);
    private Map<String, DocumentModelList> currentDocumentParentsListMap = null;
    private Map<String, DocumentModel> spaceDocMap = null;
    private Map<String, DocumentModel> sectionPublicationAreaMap = null;
    private Map<String, DocumentModel> documentDomainMap = null;
    private List<PathElement> parents;

    @Override
    public String getCurrentLifeCycleState() throws ClientException {
        try {
            DocumentModel currDoc = this.getCurrentDocument();
            return this.documentManager.getCurrentLifeCycleState(currDoc.getRef());
        }
        catch (ClientException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }

    public String navigateToRef(DocumentRef docRef) throws ClientException {
        String goTo = "view";
        if (this.documentManager == null) {
            throw new IllegalStateException("documentManager not initialized");
        }
        DocumentModel doc = null;
        DocumentModelList docs = null;
        if (docRef instanceof WebIdRef) {
            try {
                docs = ToutaticeDocumentResolver.resolveReference((CoreSession)this.documentManager, (WebIdRef)((WebIdRef)docRef));
            }
            catch (DocumentException e) {
                throw new ClientException((Throwable)e);
            }
            catch (DocumentSecurityException dse) {
                throw new ClientException((ClientException)((Object)dse));
            }
        } else {
            doc = this.documentManager.getDocument(docRef);
            goTo = this.navigateToDocument(doc, "view");
        }
        if (CollectionUtils.isNotEmpty((Collection)docs)) {
            if (docs.size() == 1) {
                DocumentModel foundDoc = (DocumentModel)docs.get(0);
                if (ToutaticeDocumentHelper.isLocaProxy((DocumentModel)foundDoc)) {
                    DocumentModel liveDoc = this.getLive((WebIdRef)docRef);
                    goTo = this.navigateToDocument(liveDoc);
                } else {
                    goTo = this.navigateToDocument(foundDoc);
                }
            } else if (docs.size() > 1) {
                DocumentModel liveDoc = this.getLive((WebIdRef)docRef);
                goTo = this.navigateToDocument(liveDoc);
                FacesMessage message = new FacesMessage(FacesMessage.SEVERITY_WARN, this.messages.get("toutatice.label.many.webid.proxies"), null);
                FacesContext faces = FacesContext.getCurrentInstance();
                faces.addMessage(null, message);
            }
        }
        return goTo;
    }

    protected DocumentModel getLive(WebIdRef webIdRef) {
        String webId = (String)webIdRef.reference();
        DocumentModel liveDoc = WebIdResolver.getLiveDocumentByWebId((CoreSession)this.documentManager, (String)webId);
        liveDoc.detach(true);
        liveDoc.attach(this.documentManager.getSessionId());
        return liveDoc;
    }

    @Override
    public DocumentModel getDocumentDomain(DocumentModel document) {
        if (null == this.documentDomainMap) {
            this.documentDomainMap = new HashMap<String, DocumentModel>();
        }
        if (null == this.documentDomainMap.get(document.getId())) {
            try {
                UnrestrictedGetDocumentDomainRunner runner = new UnrestrictedGetDocumentDomainRunner(this.documentManager, document);
                runner.runUnrestricted();
            }
            catch (Exception e) {
                log.error((Object)("Failed to retrieve the document domain for '" + document.getName() + "', error: " + e.getMessage()));
            }
        }
        return this.documentDomainMap.get(document.getId());
    }

    @Override
    public DocumentModel getCurrentPublicationArea() {
        return this.getPublicationArea(this.getCurrentDocument());
    }

    @Override
    public DocumentModel getPublicationArea(DocumentModel document) {
        DocumentModel area = ToutaticeGlobalConst.NULL_DOCUMENT_MODEL;
        if (null != document) {
            area = this.getSpaceDoc(document);
            if (!ToutaticeDocumentHelper.isAPublicationSpaceDocument((DocumentModel)area)) {
                area = ToutaticeGlobalConst.NULL_DOCUMENT_MODEL;
            }
        } else {
            log.warn((Object)"Failed to get the publication area: null current document.");
        }
        return area;
    }

    public boolean isASpaceDocument(DocumentModel document) {
        return null != document ? ToutaticeDocumentHelper.isASpaceDocument((DocumentModel)document) : false;
    }

    @Override
    public DocumentModel getCurrentWorkspaceArea() {
        return this.getWorkspaceArea(this.getCurrentDocument());
    }

    public DocumentModel getWorkspaceArea(DocumentModel document) {
        DocumentModel area = ToutaticeGlobalConst.NULL_DOCUMENT_MODEL;
        if (null != document) {
            DocumentModel space = this.getSpaceDoc(document);
            if (ToutaticeDocumentHelper.isAWorkSpaceDocument((DocumentModel)space)) {
                area = space;
            }
        } else {
            log.warn((Object)"Failed to get the workspace area: null current document.");
        }
        return area;
    }

    public DocumentModel getCurrentSpaceDoc() {
        return this.getSpaceDoc(this.getCurrentDocument());
    }

    @Override
    public DocumentModel getSpaceDoc(DocumentModel document) {
        if (null == document) {
            log.warn((Object)"Failed to get the space doc: null current document.");
            return ToutaticeGlobalConst.NULL_DOCUMENT_MODEL;
        }
        if (null == this.spaceDocMap) {
            this.spaceDocMap = new HashMap<String, DocumentModel>();
        }
        if (null == this.spaceDocMap.get(document.getId())) {
            this.spaceDocMap.put(document.getId(), ToutaticeGlobalConst.NULL_DOCUMENT_MODEL);
            try {
                DocumentModelList spaceDocsList = ToutaticeDocumentHelper.getParentSpaceList((CoreSession)this.documentManager, (DocumentModel)document, (boolean)true, (boolean)true, (boolean)true);
                if (null != spaceDocsList && !spaceDocsList.isEmpty()) {
                    this.spaceDocMap.put(document.getId(), (DocumentModel)spaceDocsList.get(0));
                }
            }
            catch (Exception e) {
                log.error((Object)("Failed to determine the parent space document of the document '" + document.getName() + "', error: " + e.getMessage()));
            }
        }
        return this.spaceDocMap.get(document.getId());
    }

    @Override
    public DocumentModel getSectionPublicationArea(DocumentModel section) {
        return this.getSectionPublicationArea(section, true);
    }

    public DocumentModel getSectionPublicationArea(DocumentModel section, boolean getHead) {
        if (null == this.sectionPublicationAreaMap) {
            this.sectionPublicationAreaMap = new HashMap<String, DocumentModel>();
        }
        if (null == this.sectionPublicationAreaMap.get(section.getId())) {
            try {
                UnrestrictedGetSectionPublicationAreaRunner runner = new UnrestrictedGetSectionPublicationAreaRunner(this.documentManager, section, getHead);
                runner.runUnrestricted();
            }
            catch (Exception e) {
                log.error((Object)("Failed to determine if the section '" + section.getName() + "' belongs to a publication area, error: " + e.getMessage()));
            }
        }
        return this.sectionPublicationAreaMap.get(section.getId());
    }

    private DocumentModelList getCurrentDocumentParentsList(CoreSession session, DocumentModel baseDoc) {
        if (null == this.currentDocumentParentsListMap) {
            this.currentDocumentParentsListMap = new HashMap<String, DocumentModelList>();
        }
        if (null == this.currentDocumentParentsListMap.get(baseDoc.getId())) {
            try {
                DocumentRef[] parentsRefsList;
                DocumentModelListImpl currentDocumentParentsList = new DocumentModelListImpl();
                if (baseDoc.isFolder()) {
                    currentDocumentParentsList.add((Object)baseDoc);
                }
                if (null != (parentsRefsList = session.getParentDocumentRefs(baseDoc.getRef())) && parentsRefsList.length > 0) {
                    currentDocumentParentsList.addAll((Collection)session.getDocuments(parentsRefsList));
                }
                if (!currentDocumentParentsList.isEmpty()) {
                    this.currentDocumentParentsListMap.put(baseDoc.getId(), (DocumentModelList)currentDocumentParentsList);
                }
            }
            catch (ClientException e) {
                log.error((Object)("Failed to get the parent list for the current document, error: " + e.getMessage()));
            }
        }
        return this.currentDocumentParentsListMap.get(baseDoc.getId());
    }

    protected void resetCurrentPath() throws ClientException {
        String logPrefix = "<toutaticeResetCurrentPath> ";
        this.parents = new ArrayList<PathElement>();
        if (null == this.documentManager) {
            log.error((Object)"<toutaticeResetCurrentPath> documentManager not initialized");
            return;
        }
        if (this.currentDocument != null) {
            if (this.currentDocument.isVersion()) {
                DocumentModel sourceDocument = this.documentManager.getSourceDocument(this.currentDocument.getRef());
                List parentList = this.documentManager.getParentDocuments(sourceDocument.getRef());
                for (DocumentModel docModel : parentList) {
                    this.parents.add(this.getDocumentPathElement(docModel));
                }
                this.parents.add((PathElement)new ArchivedVersionsPathElement(sourceDocument));
                this.parents.add((PathElement)new VersionDocumentPathElement(this.currentDocument));
            } else if (this.currentDocumentParents != null) {
                for (DocumentModel docModel : this.currentDocumentParents) {
                    this.parents.add(this.getDocumentPathElement(docModel));
                }
                if (this.currentDocument.isProxy() && "approved".equals(this.currentDocument.getCurrentLifeCycleState())) {
                    UnrestrictedGetParentsInfoRunner runner = new UnrestrictedGetParentsInfoRunner(this.documentManager, this.currentDocument);
                    runner.runUnrestricted();
                }
            }
        }
    }

    public List<PathElement> getCurrentPathList() throws ClientException {
        if (this.parents == null) {
            this.resetCurrentPath();
        }
        return this.parents;
    }

    @Override
    @Observer(value={"documentSelectionChanged", "domainSelectionChanged", "contentRootSelectionChanged", "documentChanged", "goHome"}, create=false)
    public void resetNavigation() throws ClientException {
        this.currentDocumentParentsListMap = null;
        this.sectionPublicationAreaMap = null;
        this.documentDomainMap = null;
        DocumentModel currentDoc = this.getCurrentDocument();
        currentDoc.reset();
        currentDoc.refresh();
    }

    private class UnrestrictedGetParentsInfoRunner
    extends UnrestrictedSessionRunner {
        private DocumentModel baseDoc;

        public UnrestrictedGetParentsInfoRunner(CoreSession session, DocumentModel document) {
            super(session);
            this.baseDoc = document;
        }

        public void run() throws ClientException {
            DocumentModel liveDoc = this.session.getWorkingCopy(this.baseDoc.getRef());
            int index = ToutaticeNavigationContextBean.this.parents.size() > 0 ? ToutaticeNavigationContextBean.this.parents.size() - 1 : 0;
            DocumentRef liveParentRef = liveDoc != null ? liveDoc.getParentRef() : null;
            DocumentRef currentDocumentParentRef = this.baseDoc.getParentRef();
            if (liveParentRef != null && this.session.hasPermission(liveDoc.getRef(), "WRITE") && currentDocumentParentRef != null && liveParentRef.equals(currentDocumentParentRef)) {
                ToutaticeNavigationContextBean.this.parents.add(index, new DocumentPathElement(liveDoc));
                ++index;
            }
            ToutaticeNavigationContextBean.this.parents.add(index, new ToutaticeProxyDocumentPathElement(this.baseDoc));
        }
    }

    private class UnrestrictedGetSectionPublicationAreaRunner
    extends UnrestrictedSessionRunner {
        private DocumentModel baseDoc;
        private boolean getHead;

        protected UnrestrictedGetSectionPublicationAreaRunner(CoreSession session, DocumentModel section, boolean getHead) {
            super(session);
            this.getHead = false;
            this.baseDoc = section;
            this.getHead = getHead;
        }

        public void run() throws ClientException {
            ToutaticeNavigationContextBean.this.sectionPublicationAreaMap.put(this.baseDoc.getId(), ToutaticeGlobalConst.NULL_DOCUMENT_MODEL);
            DocumentModelList currentParentsList = ToutaticeNavigationContextBean.this.getCurrentDocumentParentsList(this.session, this.baseDoc);
            if (null != currentParentsList && 0 < currentParentsList.size()) {
                for (DocumentModel parent : currentParentsList) {
                    if (!parent.hasFacet("MasterPublishSpace")) continue;
                    ToutaticeNavigationContextBean.this.sectionPublicationAreaMap.put(this.baseDoc.getId(), parent);
                    if (this.getHead) continue;
                    break;
                }
            }
        }
    }

    private class UnrestrictedGetDocumentDomainRunner
    extends UnrestrictedSessionRunner {
        private DocumentModel baseDoc;

        public UnrestrictedGetDocumentDomainRunner(CoreSession session, DocumentModel document) {
            super(session);
            this.baseDoc = document;
        }

        public void run() throws ClientException {
            DocumentModelList currentParentsList = ToutaticeNavigationContextBean.this.getCurrentDocumentParentsList(this.session, this.baseDoc);
            if (null != currentParentsList && 0 < currentParentsList.size()) {
                for (DocumentModel parent : currentParentsList) {
                    if (!"Domain".equals(parent.getType())) continue;
                    ToutaticeNavigationContextBean.this.documentDomainMap.put(this.baseDoc.getId(), parent);
                    break;
                }
            }
        }
    }
}

