/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.es.dafpic.reader;

import fr.toutatice.es.dafpic.model.CompositeDocumentModelImpl;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.Path;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.impl.DocumentModelImpl;
import org.nuxeo.elasticsearch.io.JsonDocumentModelReader;

public class DafpicJsonDocumentModelReader
extends JsonDocumentModelReader {
    private static final Log log = LogFactory.getLog(DafpicJsonDocumentModelReader.class);
    protected Map<String, Object> denormalizedSource;
    protected String sessionId;

    public DafpicJsonDocumentModelReader(String sid, Map<String, Object> source) {
        super(source);
        this.denormalizedSource = source;
        this.sessionId = sid;
    }

    public DocumentModel getDocumentModel() {
        DocumentModelImpl documentModel = (DocumentModelImpl)super.getDocumentModel();
        CompositeDocumentModelImpl stage = new CompositeDocumentModelImpl((DocumentModel)documentModel);
        HashMap denormalizedAgency = (HashMap)this.denormalizedSource.get("stage:agence");
        stage.setLinkedDocument("stage:agence", this.getLinkedDocumentModel(denormalizedAgency));
        return stage;
    }

    public DocumentModel getLinkedDocumentModel(Map<String, Object> denormalizedSource) {
        assert (denormalizedSource != null);
        String id = this.getPropertyAsString(denormalizedSource, "ecm:uuid");
        String path = this.getPropertyAsString(denormalizedSource, "ecm:path");
        String parentId = this.getPropertyAsString(denormalizedSource, "ecm:parentId");
        String repository = this.getPropertyAsString(denormalizedSource, "ecm:repository");
        DocumentModelImpl doc = new DocumentModelImpl(this.sessionId, this.getType(denormalizedSource), id, new Path(path), (DocumentRef)new IdRef(id), (DocumentRef)new IdRef(parentId), null, null, null, repository, false);
        for (String prop : denormalizedSource.keySet()) {
            String value;
            String schema = prop.split(":")[0];
            String key = prop.split(":")[1];
            if (denormalizedSource.get(prop) == null || (value = this.getPropertyAsString(denormalizedSource, prop)).isEmpty() || "[]".equals(value)) continue;
            if ("ecm".equals(schema)) {
                switch (key) {
                    case "isProxy": {
                        doc.setIsProxy(Boolean.valueOf(value).booleanValue());
                        break;
                    }
                    case "currentLifeCycleState": {
                        doc.prefetchCurrentLifecycleState(value);
                        break;
                    }
                    case "versionLabel": 
                    case "mixinType": {
                        break;
                    }
                }
                continue;
            }
            try {
                doc.setPropertyValue(prop, (Serializable)((Object)value));
            }
            catch (ClientException e) {
                log.info((Object)String.format("fetchDocFromEs can not set property %s to %s", key, value));
            }
        }
        doc.setIsImmutable(true);
        return doc;
    }

    protected String getType(Map<String, Object> denormalizedSource) {
        return this.getPropertyAsString(denormalizedSource, "ecm:primaryType");
    }

    protected String getPropertyAsString(Map<String, Object> denormalizedSource, String name) {
        Object prop = denormalizedSource.get(name);
        return prop == null ? "" : prop.toString();
    }
}

