/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.es.dafpic.writer;

import fr.toutatice.ecm.platform.core.helper.ToutaticeDirectoryMngtHelper;
import fr.toutatice.ecm.platform.core.helper.ToutaticeDocumentHelper;
import fr.toutatice.ecm.platform.core.utils.exception.ToutaticeException;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.ws.rs.Produces;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.ext.Provider;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonGenerator;
import org.nuxeo.ecm.automation.jaxrs.io.documents.JsonESDocumentWriter;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.Filter;
import org.nuxeo.ecm.core.api.model.DocumentPart;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.schema.types.Field;
import org.nuxeo.ecm.core.schema.types.QName;
import org.nuxeo.ecm.platform.web.common.vh.VirtualHostHelper;

@Provider
@Produces(value={"application/json+esentity"})
public class DenormalizationJsonESDocumentWriter
extends JsonESDocumentWriter {
    private static final Log log = LogFactory.getLog(DenormalizationJsonESDocumentWriter.class);
    protected static CoreSession session;

    public void writeDoc(JsonGenerator jg, DocumentModel doc, String[] schemas, Map<String, String> contextParameters, HttpHeaders headers) throws IOException {
        super.writeDoc(jg, doc, schemas, contextParameters, headers);
    }

    protected void writeSchemas(JsonGenerator jg, DocumentModel doc, String[] schemas) throws IOException {
        session = doc.getCoreSession();
        if (schemas == null || schemas.length == 1 && "*".equals(schemas[0])) {
            schemas = doc.getSchemas();
        }
        for (String schema : schemas) {
            this.writeDenormalizedProperties(jg, doc, schema, null);
        }
    }

    protected void writeDenormalizedProperties(JsonGenerator jg, DocumentModel doc, String schema, ServletRequest request) throws IOException {
        DocumentPart part = doc.getPart(schema);
        if (part == null) {
            return;
        }
        String prefix = part.getSchema().getNamespace().prefix;
        if (prefix == null || prefix.length() == 0) {
            prefix = schema;
        }
        prefix = prefix + ":";
        String blobUrlPrefix = null;
        if (request != null) {
            StringBuilder sb = new StringBuilder(VirtualHostHelper.getBaseURL((ServletRequest)request));
            sb.append("nxbigfile/").append(doc.getRepositoryName()).append("/").append(doc.getId()).append("/");
            blobUrlPrefix = sb.toString();
        }
        for (Property p : part.getChildren()) {
            jg.writeFieldName(prefix + p.getField().getName().getLocalName());
            DenormalizationJsonESDocumentWriter.writePropertyValue((JsonGenerator)jg, (Property)p, (String)blobUrlPrefix);
            Field field = p.getField();
            QName name = field.getName();
            String prefixedName = name.getPrefixedName();
            if (!this.isStage(doc)) continue;
            if (this.isFormation(prefixedName)) {
                this.writeDenormalizedProperty(jg, p, prefixedName, "stage:formation", "Formation", "ttc:webid");
                continue;
            }
            if (!this.isContacts(prefixedName)) continue;
            this.writeDenormalizedListProperty(jg, p, prefixedName, "stage:contacts", "ContactAgence", "ttc:webid");
        }
        if (this.isStage(doc)) {
            this.writeParentDenormalizedProperty(jg, doc, "stage:agence", "Agence");
            this.writeParentDenormalizedProperty(jg, doc, "stage:greta", "Greta");
        }
    }

    private void writeDenormalizedProperty(JsonGenerator jg, Property p, String prefixedName, String esField, String type, String targetRef) throws IOException, JsonGenerationException {
        Serializable value = p.getValue();
        if (value != null && value instanceof String) {
            String tgtRefValue = (String)((Object)value);
            String query = String.format("select * from %s where %s = \"%s\" %s", type, targetRef, tgtRefValue, " and ecm:mixinType != 'HiddenInNavigation' AND ecm:isProxy = 0 AND ecm:isCheckedInVersion = 0 AND ecm:currentLifeCycleState != 'deleted'");
            DocumentModelList refDocs = session.query(query);
            if (CollectionUtils.isNotEmpty((Collection)refDocs) && refDocs.size() == 1) {
                DocumentModel refDoc = (DocumentModel)refDocs.get(0);
                jg.writeFieldName(esField);
                super.writeESDocument(jg, refDoc, refDoc.getSchemas(), null);
            } else {
                log.error((Object)("No " + type + " with " + targetRef + ": " + tgtRefValue));
            }
        }
    }

    private void writeParentDenormalizedProperty(JsonGenerator jg, DocumentModel doc, String esField, final String type) throws IOException, JsonGenerationException {
        DocumentModelList parentList = ToutaticeDocumentHelper.getParentList((CoreSession)session, (DocumentModel)doc, (Filter)new Filter(){
            private static final long serialVersionUID = 1L;

            public boolean accept(DocumentModel docModel) {
                return docModel.getType().equals(type);
            }
        }, (boolean)true, (boolean)true);
        if (CollectionUtils.isNotEmpty((Collection)parentList) && parentList.size() == 1) {
            DocumentModel parent = (DocumentModel)parentList.get(0);
            jg.writeFieldName(esField);
            super.writeESDocument(jg, parent, parent.getSchemas(), null);
        } else {
            log.error((Object)("No " + type + " for " + doc.getPathAsString()));
        }
    }

    private void writeDenormalizedListProperty(JsonGenerator jg, Property p, String prefixedName, String esField, String type, String targetRef) throws IOException, JsonGenerationException {
        Object[] tgtRefsArray;
        String tgtRefValues;
        Serializable value = p.getValue();
        if (value != null && value instanceof String && StringUtils.isNotBlank((String)(tgtRefValues = (String)((Object)value))) && ArrayUtils.isNotEmpty((Object[])(tgtRefsArray = StringUtils.split((String)tgtRefValues, (String)";")))) {
            List<Object> tgtRefs = Arrays.asList(tgtRefsArray);
            Iterator<Object> iterator = tgtRefs.iterator();
            jg.writeArrayFieldStart(esField);
            while (iterator.hasNext()) {
                String tgtRefValue = (String)iterator.next();
                String query = String.format("select * from %s where %s = \"%s\" %s", type, targetRef, tgtRefValue, " and ecm:mixinType != 'HiddenInNavigation' AND ecm:isProxy = 0 AND ecm:isCheckedInVersion = 0 AND ecm:currentLifeCycleState != 'deleted'");
                DocumentModelList refDocs = session.query(query);
                if (CollectionUtils.isNotEmpty((Collection)refDocs) && refDocs.size() == 1) {
                    DocumentModel refDoc = (DocumentModel)refDocs.get(0);
                    super.writeESDocument(jg, refDoc, refDoc.getSchemas(), null);
                    continue;
                }
                if ("ContactAgence".equals(type) && (StringUtils.isBlank((String)tgtRefValue) || "null".equals(tgtRefValue))) continue;
                log.error((Object)("No " + type + " with " + targetRef + ": " + tgtRefValue));
            }
            jg.writeEndArray();
        }
    }

    private void writeDenormalizedVocabulary(JsonGenerator jg, Property p, String esField, String vocabName) {
        Serializable value = p.getValue();
        try {
            DocumentModelList documentModelList = ToutaticeDirectoryMngtHelper.instance().getEntries(vocabName);
        }
        catch (ToutaticeException e) {
            log.error((Object)("can't get vocabulary: " + vocabName));
        }
    }

    private boolean isFormation(String prefixedName) {
        return "stage:refFormation".equals(prefixedName);
    }

    private boolean isContacts(String prefixedName) {
        return "stage:refContacts".equals(prefixedName);
    }

    private boolean isStage(DocumentModel doc) {
        return "Stage".equals(doc.getType());
    }

    private boolean isNiveauVocab(String prefixedName) {
        return "stage:niveauValidation".equals(prefixedName);
    }

    private boolean isModaliteVocab(String prefixedName) {
        return "stage:modalite".equals(prefixedName);
    }
}

