/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.theme.properties;

import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import org.nuxeo.theme.Utils;
import org.nuxeo.theme.properties.FieldInfo;
import org.nuxeo.theme.themes.ThemeIOException;

public class FieldIO {
    public static FieldInfo getFieldInfo(Class<?> c, String name) {
        try {
            return c.getField(name).getAnnotation(FieldInfo.class);
        }
        catch (SecurityException e) {
            return null;
        }
        catch (NoSuchFieldException e) {
            return null;
        }
    }

    public static void updateFieldsFromProperties(Object object, Properties properties) throws ThemeIOException {
        Enumeration<?> names = properties.propertyNames();
        while (names.hasMoreElements()) {
            Field field;
            String name = (String)names.nextElement();
            String value = properties.getProperty(name);
            Class<?> c = object.getClass();
            FieldInfo fieldInfo = FieldIO.getFieldInfo(c, name);
            if (fieldInfo == null) continue;
            try {
                field = c.getField(name);
            }
            catch (SecurityException e) {
                throw new ThemeIOException(e);
            }
            catch (NoSuchFieldException e) {
                throw new ThemeIOException("Failed to set field '" + name + "' on " + c.getCanonicalName());
            }
            Class<?> fieldType = field.getType();
            Type fieldGenericType = field.getGenericType();
            if (fieldType.equals(Boolean.TYPE) || fieldType.equals(Boolean.class)) {
                try {
                    field.set(object, Boolean.parseBoolean(value));
                    continue;
                }
                catch (IllegalArgumentException e) {
                    throw new ThemeIOException(e);
                }
                catch (IllegalAccessException e) {
                    throw new ThemeIOException(e);
                }
            }
            if (fieldType.equals(String.class)) {
                try {
                    field.set(object, value);
                    continue;
                }
                catch (IllegalArgumentException e) {
                    throw new ThemeIOException(e);
                }
                catch (IllegalAccessException e) {
                    throw new ThemeIOException(e);
                }
            }
            if (fieldType.equals(Integer.TYPE) || fieldType.equals(Integer.class)) {
                try {
                    if ("".equals(value)) {
                        field.set(object, null);
                        continue;
                    }
                    field.set(object, Integer.valueOf(value));
                    continue;
                }
                catch (NumberFormatException e) {
                    throw new ThemeIOException("Failed to parse integer value: '" + value + "'");
                }
                catch (IllegalArgumentException e) {
                    throw new ThemeIOException(e);
                }
                catch (IllegalAccessException e) {
                    throw new ThemeIOException(e);
                }
            }
            if (fieldGenericType instanceof ParameterizedType) {
                if (!fieldType.equals(ArrayList.class) && !fieldType.equals(List.class) && !fieldType.equals(Collection.class)) continue;
                Type[] actualTypes = ((ParameterizedType)fieldGenericType).getActualTypeArguments();
                if (actualTypes.length > 1) {
                    throw new ThemeIOException("Only one-dimension arrays are supported.");
                }
                if (!actualTypes[0].equals(String.class)) continue;
                List<Object> list = new ArrayList();
                try {
                    list = Utils.csvToList(value);
                }
                catch (IOException e) {
                    throw new ThemeIOException(e);
                }
                try {
                    field.set(object, list);
                    continue;
                }
                catch (IllegalArgumentException e) {
                    throw new ThemeIOException(e);
                }
                catch (IllegalAccessException e) {
                    throw new ThemeIOException(e);
                }
            }
            throw new ThemeIOException("Cannot update field type '" + name + "' of " + c.getCanonicalName() + " because " + fieldType.getCanonicalName() + " is not supported.");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Properties dumpFieldsToProperties(Object object) throws ThemeIOException {
        Properties properties = new Properties();
        Class<?> c = object.getClass();
        for (Field field : c.getDeclaredFields()) {
            Object value;
            Class<?> fieldType = field.getType();
            Type fieldGenericType = field.getGenericType();
            String fieldName = field.getName();
            FieldInfo fieldInfo = FieldIO.getFieldInfo(c, fieldName);
            if (fieldInfo == null) continue;
            String property = "";
            try {
                value = field.get(object);
            }
            catch (IllegalAccessException e) {
                throw new ThemeIOException(e);
            }
            catch (IllegalArgumentException e) {
                throw new ThemeIOException(e);
            }
            if (fieldType.equals(Boolean.TYPE) || fieldType.equals(Boolean.class)) {
                property = value == null ? "false" : (Boolean.parseBoolean(value.toString()) ? "true" : "false");
            } else if (fieldType.equals(String.class)) {
                property = value == null ? "" : value.toString();
            } else if (fieldType.equals(Integer.TYPE) || fieldType.equals(Integer.class)) {
                property = value == null ? "" : value.toString();
            } else {
                if (!(fieldGenericType instanceof ParameterizedType)) throw new ThemeIOException("Cannot extract property from field type '" + fieldName + "' of " + c.getCanonicalName() + " because " + fieldType.getCanonicalName() + " is not supported.");
                if (fieldType.equals(ArrayList.class) || fieldType.equals(List.class) || fieldType.equals(Collection.class)) {
                    Type[] actualTypes = ((ParameterizedType)fieldGenericType).getActualTypeArguments();
                    if (actualTypes.length > 1) {
                        throw new ThemeIOException("Only one-dimension arrays are supported.");
                    }
                    if (!actualTypes[0].equals(String.class)) throw new ThemeIOException("Only list of strings are supported.");
                    property = value == null ? "" : Utils.listToCsv((List)value);
                }
            }
            properties.setProperty(fieldName, property);
        }
        return properties;
    }
}

