/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.mail.listener.action;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.AutomationService;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.api.pathsegment.PathSegmentService;
import org.nuxeo.ecm.platform.mail.action.ExecutionContext;
import org.nuxeo.ecm.platform.mail.listener.action.AbstractMailAction;
import org.nuxeo.runtime.api.Framework;

public class CreateDocumentsFromAutomationChainAction
extends AbstractMailAction {
    private static final Log log = LogFactory.getLog(CreateDocumentsFromAutomationChainAction.class);
    protected String chainName;
    public Pattern stupidRegexp = Pattern.compile("^[- .,;?!:/\\\\'\"]*$");

    public CreateDocumentsFromAutomationChainAction(String chainName) {
        this.chainName = chainName;
    }

    protected String getChainName() {
        if (this.chainName == null) {
            return Framework.getProperty((String)"org.nuxeo.mail.automation.chain", (String)"CreateMailDocumentFromAutomation");
        }
        return this.chainName;
    }

    protected String generateMailName(String subject) {
        PathSegmentService pss = (PathSegmentService)Framework.getLocalService(PathSegmentService.class);
        return pss.generatePathSegment(subject + System.currentTimeMillis() % 10000L);
    }

    @Override
    public boolean execute(ExecutionContext context) throws Exception {
        CoreSession session = this.getCoreSession(context);
        if (session == null) {
            log.error((Object)"Could not open CoreSession");
            return false;
        }
        AutomationService as = (AutomationService)Framework.getService(AutomationService.class);
        OperationContext automationCtx = new OperationContext(session);
        automationCtx.putAll((Map)context);
        ExecutionContext initialContext = context.getInitialContext();
        String parentPath = (String)initialContext.get("parentPath");
        DocumentModel mailFolder = session.getDocument((DocumentRef)new PathRef(parentPath));
        automationCtx.put("mailFolder", (Object)mailFolder);
        automationCtx.put("executionContext", (Object)initialContext);
        String subject = (String)context.get("subject");
        automationCtx.put("mailDocumentName", (Object)this.generateMailName(subject));
        List attachments = (List)context.get("attachments");
        if (attachments == null) {
            automationCtx.put("attachments", (Object)Collections.EMPTY_LIST);
        }
        as.run(automationCtx, this.getChainName());
        return true;
    }
}

