/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation;

import java.util.ArrayList;
import java.util.List;
import javax.security.auth.login.LoginContext;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;

public class LoginStack {
    protected List<Entry> stack = new ArrayList<Entry>();
    protected CoreSession originalSession;
    protected CoreSession currentSession;

    public LoginStack(CoreSession session) {
        this.setSession(session);
    }

    public void setSession(CoreSession session) {
        this.originalSession = session;
        this.currentSession = session;
    }

    public CoreSession getSession() {
        return this.currentSession;
    }

    public void push(LoginContext lc) throws OperationException {
        Entry entry = new Entry(lc);
        try {
            String repositoryName = this.originalSession != null ? this.originalSession.getRepositoryName() : null;
            this.currentSession = entry.session = CoreInstance.openCoreSession((String)repositoryName);
            this.stack.add(entry);
        }
        catch (Exception e) {
            throw new OperationException("Failed to create new core session for loginAs", e);
        }
    }

    public Entry peek() {
        if (!this.stack.isEmpty()) {
            return this.stack.get(this.stack.size() - 1);
        }
        return null;
    }

    public void pop() throws OperationException {
        if (!this.stack.isEmpty()) {
            Entry entry = this.stack.remove(this.stack.size() - 1);
            entry.dispose();
            entry = this.peek();
            this.currentSession = entry != null ? entry.session : this.originalSession;
            if (this.currentSession != null) {
                this.refreshSession(this.currentSession);
            }
        }
    }

    protected void refreshSession(CoreSession session) throws OperationException {
        if (session != null && !session.isStateSharedByAllThreadSessions()) {
            try {
                session.save();
            }
            catch (Exception e) {
                throw new OperationException(e);
            }
        }
    }

    protected void clear() throws OperationException {
        if (!this.stack.isEmpty()) {
            for (int i = this.stack.size() - 1; i > -1; --i) {
                this.stack.get(i).dispose();
            }
            this.stack.clear();
            this.currentSession = this.originalSession;
            if (this.currentSession != null) {
                this.refreshSession(this.currentSession);
            }
            this.stack.clear();
        }
    }

    public static class Entry {
        public LoginContext lc;
        public CoreSession session;

        public Entry(LoginContext lc) {
            this(lc, null);
        }

        public Entry(LoginContext lc, CoreSession session) {
            this.lc = lc;
            this.session = session;
        }

        public final boolean hasSession() {
            return this.session != null;
        }

        public final void dispose() throws OperationException {
            block12: {
                try {
                    if (this.session == null) break block12;
                    try {
                        this.session.save();
                    }
                    finally {
                        this.session.close();
                    }
                }
                catch (Exception e) {
                    throw new OperationException(e);
                }
                finally {
                    try {
                        this.session = null;
                        this.lc.logout();
                        this.lc = null;
                    }
                    catch (Exception e) {
                        throw new OperationException(e);
                    }
                }
            }
        }
    }
}

