/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.service.lock;

import fr.toutatice.ecm.platform.service.lock.ToutaticeLockService;
import java.security.Principal;
import java.util.HashMap;
import java.util.Map;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.Lock;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;

public class ToutaticeLockServiceImpl
implements ToutaticeLockService {
    public Map<String, Object> fetchInfos(CoreSession coreSession, DocumentModel currentDocument) throws ClientException {
        HashMap<String, Object> lockInfo = new HashMap<String, Object>();
        Lock lock = currentDocument.getLockInfo();
        NuxeoPrincipal principal = (NuxeoPrincipal)coreSession.getPrincipal();
        if (!currentDocument.isProxy() && !currentDocument.isFolder()) {
            if (lock != null) {
                lockInfo.put("lockCreationDate", lock.getCreated());
                lockInfo.put("lockOwner", lock.getOwner());
                if ((principal.isAdministrator() || coreSession.hasPermission((Principal)principal, currentDocument.getRef(), "Everything") || coreSession.hasPermission((Principal)principal, currentDocument.getRef(), "Write")) && !currentDocument.isVersion()) {
                    lockInfo.put("lockStatus", (Object)ToutaticeLockService.LockStatus.can_unlock);
                } else {
                    lockInfo.put("lockStatus", (Object)ToutaticeLockService.LockStatus.locked);
                }
            } else if ((principal.isAdministrator() || coreSession.hasPermission((Principal)principal, currentDocument.getRef(), "Everything") || coreSession.hasPermission((Principal)principal, currentDocument.getRef(), "Write")) && !currentDocument.isVersion()) {
                lockInfo.put("lockStatus", (Object)ToutaticeLockService.LockStatus.can_lock);
            }
        }
        return lockInfo;
    }
}

