/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.service.portalviews.adapter.dates;

import fr.toutatice.ecm.platform.core.helper.ToutaticeSilentProcessRunnerHelper;
import fr.toutatice.ecm.platform.service.portalviews.adapter.WidgetsAdapterService;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventContext;
import org.nuxeo.ecm.core.event.EventListener;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.core.schema.types.Field;
import org.nuxeo.ecm.core.schema.types.Schema;
import org.nuxeo.ecm.platform.forms.layout.api.LayoutDefinition;
import org.nuxeo.ecm.platform.forms.layout.api.LayoutRowDefinition;
import org.nuxeo.ecm.platform.forms.layout.api.WidgetReference;
import org.nuxeo.ecm.platform.forms.layout.service.WebLayoutManager;
import org.nuxeo.ecm.platform.types.Layouts;
import org.nuxeo.ecm.platform.types.Type;
import org.nuxeo.ecm.platform.types.TypeManager;
import org.nuxeo.runtime.api.Framework;

public class WidgetsDatesAdapterListener
implements EventListener {
    public static final String DATE_FORMAT = "dd/MM/yyyy";
    public static final String TIME_FORMAT = "HH:mm";
    public static final String PV_DATE_START_PROPERTY = "ttcevt:dateBegin";
    public static final String PV_DATE_END_PROPERTY = "ttcevt:dateEnd";
    protected static WidgetsAdapterService waSrv;
    protected static TypeManager typeMng;
    protected static WebLayoutManager wlMng;

    public void handleEvent(Event event) throws ClientException {
        String eventName;
        if (event.getContext() instanceof DocumentEventContext && ("documentCreated".equals(eventName = event.getName()) || "beforeDocumentModification".equals(eventName))) {
            EventContext ctx = event.getContext();
            DocumentEventContext docCtx = (DocumentEventContext)event.getContext();
            DocumentModel document = docCtx.getSourceDocument();
            CoreSession session = ctx.getCoreSession();
            if (document != null && !document.isImmutable() && document.hasSchema("toutatice_event")) {
                DateNTimeSilentFiller runner = new DateNTimeSilentFiller(session, document, eventName);
                runner.silentRun(false);
            }
        }
    }

    protected boolean hasDateLikeSchema(String nxWidgetName) {
        boolean has = false;
        List<String> nxFields = WidgetsDatesAdapterListener.getWidgetsAdapterService().getNxFields(nxWidgetName);
        if (nxFields != null) {
            int nbFields = 0;
            for (String nxField : nxFields) {
                String[] split = StringUtils.split((String)nxField, (String)":");
                if (split != null && split.length > 0) {
                    String schemaPrefix = split[0];
                    SchemaManager schemaManager = (SchemaManager)Framework.getService(SchemaManager.class);
                    Schema schemaFromPrefix = schemaManager.getSchemaFromPrefix(schemaPrefix);
                    if (schemaFromPrefix != null) {
                        Field field = schemaFromPrefix.getField(nxField);
                        org.nuxeo.ecm.core.schema.types.Type fieldType = field.getType();
                        has = nbFields == 0 ? "date".equals(fieldType.getName()) : (has &= "date".equals(fieldType.getName()));
                    }
                }
                ++nbFields;
            }
        }
        return has;
    }

    public static WidgetsAdapterService getWidgetsAdapterService() {
        if (waSrv == null) {
            waSrv = (WidgetsAdapterService)Framework.getService(WidgetsAdapterService.class);
        }
        return waSrv;
    }

    public static WebLayoutManager getWebLayoutManger() {
        if (wlMng == null) {
            wlMng = (WebLayoutManager)Framework.getService(WebLayoutManager.class);
        }
        return wlMng;
    }

    public static TypeManager getTypeManager() {
        if (typeMng == null) {
            typeMng = (TypeManager)Framework.getService(TypeManager.class);
        }
        return typeMng;
    }

    private class DateNTimeSilentFiller
    extends ToutaticeSilentProcessRunnerHelper {
        private DocumentModel document;
        private String eventName;

        public DateNTimeSilentFiller(CoreSession session, DocumentModel document, String eventName) {
            super(session);
            this.document = document;
            this.eventName = eventName;
        }

        public void run() throws ClientException {
            boolean isChangeableDocument = "documentCreated".equals(this.eventName);
            WidgetsAdapterService widgetsAdapterService = WidgetsDatesAdapterListener.getWidgetsAdapterService();
            Map<String, String> widgetsMappings = widgetsAdapterService.getWidgetsMappings();
            if (MapUtils.isNotEmpty(widgetsMappings)) {
                Set<Map.Entry<String, String>> widgetsMapEntries = widgetsMappings.entrySet();
                for (Map.Entry<String, String> widgetMapEntry : widgetsMapEntries) {
                    String nxWidgetName = widgetMapEntry.getKey();
                    String pvWidgetName = widgetMapEntry.getValue();
                    boolean docHasWidget = this.documentHasWidget(this.document, nxWidgetName);
                    if (!docHasWidget || !WidgetsDatesAdapterListener.this.hasDateLikeSchema(nxWidgetName)) continue;
                    if (widgetsAdapterService.isInPortalViewContext()) {
                        this.fromTTCToNxDate(nxWidgetName, pvWidgetName);
                    } else {
                        this.fromNxToTTCDate(nxWidgetName, pvWidgetName);
                    }
                    if (!isChangeableDocument) continue;
                    this.session.saveDocument(this.document);
                }
            }
        }

        private boolean documentHasWidget(DocumentModel document, String nxWidgetName) {
            boolean has = false;
            Type type = WidgetsDatesAdapterListener.getTypeManager().getType(document.getType());
            Map layoutsByMode = type.getLayouts();
            Set entrySet = layoutsByMode.entrySet();
            Iterator itLayouts = entrySet.iterator();
            while (itLayouts.hasNext() && !has) {
                String[] layoutsNames;
                Layouts layouts = (Layouts)itLayouts.next().getValue();
                for (String layoutName : layoutsNames = layouts.getLayouts()) {
                    LayoutDefinition layoutDefinition = WidgetsDatesAdapterListener.getWebLayoutManger().getLayoutDefinition(layoutName);
                    LayoutRowDefinition[] rows = layoutDefinition.getRows();
                    if (rows == null) continue;
                    List<LayoutRowDefinition> rowsAsList = Arrays.asList(rows);
                    Iterator<LayoutRowDefinition> itRows = rowsAsList.iterator();
                    while (itRows.hasNext() && !has) {
                        WidgetReference[] widgetReferences = itRows.next().getWidgetReferences();
                        if (widgetReferences == null) continue;
                        List<WidgetReference> widgetsAsList = Arrays.asList(widgetReferences);
                        Iterator<WidgetReference> itWidgets = widgetsAsList.iterator();
                        while (itWidgets.hasNext() && !has) {
                            if (!nxWidgetName.equals(itWidgets.next().getName())) continue;
                            has = true;
                        }
                    }
                }
            }
            return has;
        }

        private void fromTTCToNxDate(String nxWidgetName, String pvWidgetName) {
            List<String> pvFields = WidgetsDatesAdapterListener.getWidgetsAdapterService().getPvFields(pvWidgetName);
            if (CollectionUtils.isNotEmpty(pvFields)) {
                List<String> nxFields;
                GregorianCalendar ttcDateTimeEnd;
                if (pvFields.contains(WidgetsDatesAdapterListener.PV_DATE_START_PROPERTY)) {
                    List<String> nxFields2;
                    GregorianCalendar ttcDateTimeStart = (GregorianCalendar)this.document.getPropertyValue("ttcevt:dateTimeBegin");
                    if (null != ttcDateTimeStart && CollectionUtils.isNotEmpty(nxFields2 = WidgetsDatesAdapterListener.getWidgetsAdapterService().getNxFields(nxWidgetName)) && nxFields2.size() == 1) {
                        this.document.setPropertyValue(nxFields2.get(0), (Serializable)ttcDateTimeStart.getTime());
                    }
                } else if (pvFields.contains(WidgetsDatesAdapterListener.PV_DATE_END_PROPERTY) && null != (ttcDateTimeEnd = (GregorianCalendar)this.document.getPropertyValue("ttcevt:dateTimeEnd")) && CollectionUtils.isNotEmpty(nxFields = WidgetsDatesAdapterListener.getWidgetsAdapterService().getNxFields(nxWidgetName)) && nxFields.size() == 1) {
                    this.document.setPropertyValue(nxFields.get(0), (Serializable)ttcDateTimeEnd.getTime());
                }
            }
        }

        private void fromNxToTTCDate(String nxWidgetName, String pvWidgetName) {
            SimpleDateFormat formatDate = new SimpleDateFormat(WidgetsDatesAdapterListener.DATE_FORMAT);
            SimpleDateFormat formatTime = new SimpleDateFormat(WidgetsDatesAdapterListener.TIME_FORMAT);
            List<String> nxFields = WidgetsDatesAdapterListener.getWidgetsAdapterService().getNxFields(nxWidgetName);
            List<String> pvFields = WidgetsDatesAdapterListener.getWidgetsAdapterService().getPvFields(pvWidgetName);
            if (CollectionUtils.isNotEmpty(pvFields)) {
                GregorianCalendar nxDateTimeEnd;
                if (pvFields.contains(WidgetsDatesAdapterListener.PV_DATE_START_PROPERTY)) {
                    GregorianCalendar nxDateTimeStart;
                    if (CollectionUtils.isNotEmpty(nxFields) && nxFields.size() == 1 && null != (nxDateTimeStart = (GregorianCalendar)this.document.getPropertyValue(nxFields.get(0)))) {
                        Date ttcDateTimeBegin = nxDateTimeStart.getTime();
                        this.document.setPropertyValue("ttcevt:dateTimeBegin", (Serializable)ttcDateTimeBegin);
                        String dateBegin = formatDate.format(ttcDateTimeBegin);
                        this.document.setPropertyValue(WidgetsDatesAdapterListener.PV_DATE_START_PROPERTY, (Serializable)((Object)dateBegin));
                        String timeBegin = formatTime.format(ttcDateTimeBegin);
                        if (StringUtils.isNotBlank((String)timeBegin)) {
                            this.document.setPropertyValue("ttcevt:timeBegin", (Serializable)((Object)timeBegin));
                        }
                    }
                } else if (pvFields.contains(WidgetsDatesAdapterListener.PV_DATE_END_PROPERTY) && CollectionUtils.isNotEmpty(nxFields) && nxFields.size() == 1 && null != (nxDateTimeEnd = (GregorianCalendar)this.document.getPropertyValue(nxFields.get(0)))) {
                    Date ttcDateTimeEnd = nxDateTimeEnd.getTime();
                    this.document.setPropertyValue("ttcevt:dateTimeEnd", (Serializable)ttcDateTimeEnd);
                    String dateEnd = formatDate.format(ttcDateTimeEnd);
                    this.document.setPropertyValue(WidgetsDatesAdapterListener.PV_DATE_END_PROPERTY, (Serializable)((Object)dateEnd));
                    String timeEnd = formatTime.format(ttcDateTimeEnd);
                    if (StringUtils.isNotBlank((String)timeEnd)) {
                        this.document.setPropertyValue("ttcevt:timeEnd", (Serializable)((Object)timeEnd));
                    }
                }
            }
        }
    }
}

