/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.service.workflows;

import fr.toutatice.ecm.platform.core.helper.ToutaticeWorkflowHelper;
import fr.toutatice.ecm.platform.service.workflows.TaskDescriptor;
import fr.toutatice.ecm.platform.service.workflows.ToutaticeTaskService;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentSecurityException;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.platform.task.Task;
import org.nuxeo.ecm.platform.task.core.helpers.TaskActorsHelper;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

public class ToutaticeTaskServiceImpl
extends DefaultComponent
implements ToutaticeTaskService {
    private static final Log log = LogFactory.getLog(ToutaticeTaskServiceImpl.class);
    private static final String TASKS_EXT_POINT = "tasks";
    private Map<String, String> tasksContribs;

    public void activate(ComponentContext context) throws Exception {
        super.activate(context);
        this.tasksContribs = new HashMap<String, String>(0);
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) throws Exception {
        if (TASKS_EXT_POINT.equals(extensionPoint)) {
            TaskDescriptor taskDesc = (TaskDescriptor)contribution;
            String taskName = taskDesc.getTaskName();
            String permission = taskDesc.getPermission();
            if (StringUtils.isNotBlank((String)taskName)) {
                this.tasksContribs.put(taskName, permission);
            }
        }
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) throws Exception {
        TaskDescriptor taskDesc;
        String taskName;
        if (TASKS_EXT_POINT.equals(extensionPoint) && StringUtils.isNotBlank((String)(taskName = (taskDesc = (TaskDescriptor)contribution).getTaskName()))) {
            this.tasksContribs.remove(taskName);
        }
    }

    public Map<String, Object> fetchInfos(CoreSession coreSession, DocumentModel currentDocument) throws ClientException {
        HashMap<String, Object> infos = new HashMap<String, Object>(0);
        if (MapUtils.isNotEmpty(this.tasksContribs)) {
            Task currentTask = null;
            boolean taskFound = false;
            String searchedTaskName = "";
            String permission = null;
            Set<String> tasksNames = this.tasksContribs.keySet();
            Iterator<String> iterator = tasksNames.iterator();
            while (iterator.hasNext() && !taskFound) {
                String taskName = iterator.next();
                Task task = this.getTask(coreSession, currentDocument, taskName);
                if (task == null) continue;
                searchedTaskName = taskName;
                currentTask = task;
                permission = this.tasksContribs.get(taskName);
                taskFound = true;
            }
            infos.put(TaskInfos.taskName.name(), searchedTaskName);
            infos.put(TaskInfos.isTaskPending.name(), this.isTaskPending(currentTask));
            infos.put(TaskInfos.isTaskInitiator.name(), this.isUserTaskInitiator(coreSession, currentTask));
            infos.put(TaskInfos.canManageTask.name(), this.canUserManageTask(coreSession, currentTask, currentDocument, permission));
        }
        return infos;
    }

    protected Task getTask(CoreSession coreSession, DocumentModel document, String taskName) {
        return ToutaticeWorkflowHelper.getTaskByName((String)taskName, (CoreSession)coreSession, (DocumentModel)document);
    }

    public Boolean isTaskPending(Task task) throws ClientException {
        Boolean isPending = Boolean.FALSE;
        if (task != null) {
            isPending = task.isOpened();
        }
        return isPending;
    }

    private Boolean isUserTaskInitiator(CoreSession coreSession, Task task) throws ClientException {
        String taskInitiator;
        Boolean isInitiator = Boolean.FALSE;
        if (task != null && StringUtils.isNotBlank((String)(taskInitiator = task.getInitiator()))) {
            NuxeoPrincipal currentUser = (NuxeoPrincipal)coreSession.getPrincipal();
            isInitiator = taskInitiator.equals(currentUser.getName());
        }
        return isInitiator;
    }

    private Boolean canUserManageTask(CoreSession coreSession, Task currentTask, DocumentModel currentDocument, String permission) throws ClientException {
        Boolean canValidate = Boolean.FALSE;
        Boolean isActor = Boolean.FALSE;
        if (currentTask != null) {
            NuxeoPrincipal principal;
            List actors = currentTask.getActors();
            if (actors != null && !actors.isEmpty() && (principal = (NuxeoPrincipal)coreSession.getPrincipal()) != null) {
                List taskActors = TaskActorsHelper.getTaskActors((NuxeoPrincipal)principal);
                isActor = CollectionUtils.isSubCollection((Collection)actors, (Collection)taskActors);
            }
            if (isActor.booleanValue()) {
                canValidate = this.checkPermission(coreSession, currentDocument, permission);
            }
        }
        return canValidate;
    }

    private Boolean checkPermission(CoreSession coreSession, DocumentModel currentDocument, String permission) throws ClientException {
        if (StringUtils.isBlank((String)permission)) {
            return Boolean.TRUE;
        }
        Boolean can = Boolean.FALSE;
        try {
            can = coreSession.hasPermission(currentDocument.getRef(), permission);
        }
        catch (ClientException e) {
            if (e instanceof DocumentSecurityException) {
                return Boolean.FALSE;
            }
            log.warn((Object)("Failed to fetch permissions for document '" + currentDocument.getPathAsString() + "', error:" + e.getMessage()));
            throw new ClientException(e);
        }
        return can;
    }

    private static enum TaskInfos {
        taskName,
        isTaskPending,
        canManageTask,
        isTaskInitiator;

    }
}

