/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.authz.support;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import org.apache.directory.server.core.authz.support.ACITupleFilter;
import org.apache.directory.server.core.authz.support.HighestPrecedenceFilter;
import org.apache.directory.server.core.authz.support.MaxImmSubFilter;
import org.apache.directory.server.core.authz.support.MaxValueCountFilter;
import org.apache.directory.server.core.authz.support.MicroOperationFilter;
import org.apache.directory.server.core.authz.support.MostSpecificProtectedItemFilter;
import org.apache.directory.server.core.authz.support.MostSpecificUserClassFilter;
import org.apache.directory.server.core.authz.support.OperationScope;
import org.apache.directory.server.core.authz.support.RelatedProtectedItemFilter;
import org.apache.directory.server.core.authz.support.RelatedUserClassFilter;
import org.apache.directory.server.core.authz.support.RestrictedByFilter;
import org.apache.directory.server.core.event.ExpressionEvaluator;
import org.apache.directory.server.core.interceptor.context.LookupOperationContext;
import org.apache.directory.server.core.partition.PartitionNexusProxy;
import org.apache.directory.server.core.subtree.RefinementEvaluator;
import org.apache.directory.server.core.subtree.RefinementLeafEvaluator;
import org.apache.directory.server.core.subtree.SubtreeEvaluator;
import org.apache.directory.server.schema.registries.AttributeTypeRegistry;
import org.apache.directory.server.schema.registries.OidRegistry;
import org.apache.directory.shared.ldap.aci.ACITuple;
import org.apache.directory.shared.ldap.aci.AuthenticationLevel;
import org.apache.directory.shared.ldap.aci.MicroOperation;
import org.apache.directory.shared.ldap.exception.LdapNoPermissionException;
import org.apache.directory.shared.ldap.name.LdapDN;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ACDFEngine {
    private final ACITupleFilter[] filters;
    public static final Collection<String> USER_LOOKUP_BYPASS;

    public ACDFEngine(OidRegistry oidRegistry, AttributeTypeRegistry attrTypeRegistry) throws NamingException {
        ExpressionEvaluator entryEvaluator = new ExpressionEvaluator(oidRegistry, attrTypeRegistry);
        SubtreeEvaluator subtreeEvaluator = new SubtreeEvaluator(oidRegistry, attrTypeRegistry);
        RefinementEvaluator refinementEvaluator = new RefinementEvaluator(new RefinementLeafEvaluator(oidRegistry));
        this.filters = new ACITupleFilter[]{new RelatedUserClassFilter(subtreeEvaluator), new RelatedProtectedItemFilter(refinementEvaluator, entryEvaluator, oidRegistry, attrTypeRegistry), new MaxValueCountFilter(), new MaxImmSubFilter(), new RestrictedByFilter(), new MicroOperationFilter(), new HighestPrecedenceFilter(), new MostSpecificUserClassFilter(), new MostSpecificProtectedItemFilter()};
    }

    public void checkPermission(PartitionNexusProxy proxy, Collection<LdapDN> userGroupNames, LdapDN username, AuthenticationLevel authenticationLevel, LdapDN entryName, String attrId, Object attrValue, Collection<MicroOperation> microOperations, Collection<ACITuple> aciTuples, Attributes entry) throws NamingException {
        if (!this.hasPermission(proxy, userGroupNames, username, authenticationLevel, entryName, attrId, attrValue, microOperations, aciTuples, entry)) {
            throw new LdapNoPermissionException();
        }
    }

    public boolean hasPermission(PartitionNexusProxy proxy, Collection<LdapDN> userGroupNames, LdapDN userName, AuthenticationLevel authenticationLevel, LdapDN entryName, String attrId, Object attrValue, Collection<MicroOperation> microOperations, Collection<ACITuple> aciTuples, Attributes entry) throws NamingException {
        if (entryName == null) {
            throw new NullPointerException("entryName");
        }
        Attributes userEntry = proxy.lookup(new LookupOperationContext(userName), USER_LOOKUP_BYPASS);
        OperationScope scope = attrId == null ? OperationScope.ENTRY : (attrValue == null ? OperationScope.ATTRIBUTE_TYPE : OperationScope.ATTRIBUTE_TYPE_AND_VALUE);
        aciTuples = new ArrayList<ACITuple>(aciTuples);
        for (ACITupleFilter filter : this.filters) {
            aciTuples = filter.filter(aciTuples, scope, proxy, userGroupNames, userName, userEntry, authenticationLevel, entryName, attrId, attrValue, entry, microOperations);
        }
        if (aciTuples.size() == 0) {
            return false;
        }
        for (ACITuple tuple : aciTuples) {
            if (tuple.isGrant()) continue;
            return false;
        }
        return true;
    }

    static {
        HashSet<String> c = new HashSet<String>();
        c.add("normalizationService");
        c.add("authenticationService");
        c.add("authorizationService");
        c.add("defaultAuthorizationService");
        c.add("schemaService");
        c.add("subentryService");
        c.add("operationalAttributeService");
        c.add("eventService");
        c.add("triggerService");
        USER_LOOKUP_BYPASS = Collections.unmodifiableCollection(c);
    }
}

