/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.exception;

import java.util.Map;
import javax.naming.Name;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchResult;
import org.apache.commons.collections.map.LRUMap;
import org.apache.directory.server.core.DirectoryServiceConfiguration;
import org.apache.directory.server.core.configuration.InterceptorConfiguration;
import org.apache.directory.server.core.interceptor.BaseInterceptor;
import org.apache.directory.server.core.interceptor.NextInterceptor;
import org.apache.directory.server.core.interceptor.context.AddOperationContext;
import org.apache.directory.server.core.interceptor.context.DeleteOperationContext;
import org.apache.directory.server.core.interceptor.context.EntryOperationContext;
import org.apache.directory.server.core.interceptor.context.GetMatchedNameOperationContext;
import org.apache.directory.server.core.interceptor.context.ListOperationContext;
import org.apache.directory.server.core.interceptor.context.LookupOperationContext;
import org.apache.directory.server.core.interceptor.context.ModifyOperationContext;
import org.apache.directory.server.core.interceptor.context.MoveAndRenameOperationContext;
import org.apache.directory.server.core.interceptor.context.MoveOperationContext;
import org.apache.directory.server.core.interceptor.context.RenameOperationContext;
import org.apache.directory.server.core.interceptor.context.SearchOperationContext;
import org.apache.directory.server.core.invocation.Invocation;
import org.apache.directory.server.core.invocation.InvocationStack;
import org.apache.directory.server.core.partition.PartitionNexus;
import org.apache.directory.server.core.partition.PartitionNexusProxy;
import org.apache.directory.shared.ldap.exception.LdapAttributeInUseException;
import org.apache.directory.shared.ldap.exception.LdapContextNotEmptyException;
import org.apache.directory.shared.ldap.exception.LdapNameAlreadyBoundException;
import org.apache.directory.shared.ldap.exception.LdapNameNotFoundException;
import org.apache.directory.shared.ldap.exception.LdapNamingException;
import org.apache.directory.shared.ldap.exception.LdapOperationNotSupportedException;
import org.apache.directory.shared.ldap.message.ModificationItemImpl;
import org.apache.directory.shared.ldap.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.schema.OidNormalizer;
import org.apache.directory.shared.ldap.util.AttributeUtils;
import org.apache.directory.shared.ldap.util.EmptyEnumeration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExceptionService
extends BaseInterceptor {
    private PartitionNexus nexus;
    private LdapDN subschemSubentryDn;
    private Map<String, OidNormalizer> normalizerMap;
    private LRUMap notAliasCache;
    private static final int DEFAULT_CACHE_SIZE = 100;

    @Override
    public void init(DirectoryServiceConfiguration factoryCfg, InterceptorConfiguration cfg) throws NamingException {
        this.nexus = factoryCfg.getPartitionNexus();
        this.normalizerMap = factoryCfg.getRegistries().getAttributeTypeRegistry().getNormalizerMapping();
        Attribute attr = this.nexus.getRootDSE(null).get("subschemaSubentry");
        this.subschemSubentryDn = new LdapDN((String)attr.get());
        this.subschemSubentryDn.normalize(this.normalizerMap);
        this.notAliasCache = new LRUMap(100);
    }

    @Override
    public void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(NextInterceptor nextInterceptor, AddOperationContext opContext) throws NamingException {
        LdapDN name = opContext.getDn();
        if (this.subschemSubentryDn.getNormName().equals(name.getNormName())) {
            throw new LdapNameAlreadyBoundException("The global schema subentry cannot be added since it exists by default.");
        }
        if (nextInterceptor.hasEntry(new EntryOperationContext(name))) {
            LdapNameAlreadyBoundException ne = new LdapNameAlreadyBoundException(name.getUpName() + " already exists!");
            ne.setResolvedName((Name)new LdapDN(name.getUpName()));
            throw ne;
        }
        LdapDN parentDn = (LdapDN)name.clone();
        parentDn.remove(name.size() - 1);
        boolean notAnAlias = false;
        LRUMap lRUMap = this.notAliasCache;
        synchronized (lRUMap) {
            notAnAlias = this.notAliasCache.containsKey((Object)parentDn.getNormName());
        }
        if (!notAnAlias) {
            Attributes attrs = null;
            try {
                attrs = nextInterceptor.lookup(new LookupOperationContext(parentDn));
            }
            catch (Exception e) {
                LdapNameNotFoundException e2 = new LdapNameNotFoundException("Parent " + parentDn.getUpName() + " not found");
                e2.setResolvedName((Name)new LdapDN(this.nexus.getMatchedName(new GetMatchedNameOperationContext(parentDn)).getUpName()));
                throw e2;
            }
            Attribute objectClass = attrs.get("objectClass");
            if (AttributeUtils.containsValueCaseIgnore((Attribute)objectClass, (Object)"alias")) {
                String msg = "Attempt to add entry to alias '" + name.getUpName() + "' not allowed.";
                ResultCodeEnum rc = ResultCodeEnum.ALIAS_PROBLEM;
                LdapNamingException e = new LdapNamingException(msg, rc);
                e.setResolvedName((Name)new LdapDN(parentDn.getUpName()));
                throw e;
            }
            LRUMap lRUMap2 = this.notAliasCache;
            synchronized (lRUMap2) {
                this.notAliasCache.put((Object)parentDn.getNormName(), (Object)parentDn);
            }
        }
        nextInterceptor.add(opContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(NextInterceptor nextInterceptor, DeleteOperationContext opContext) throws NamingException {
        LdapDN name = opContext.getDn();
        if (name.getNormName().equalsIgnoreCase(this.subschemSubentryDn.getNormName())) {
            throw new LdapOperationNotSupportedException("Can not allow the deletion of the subschemaSubentry (" + this.subschemSubentryDn + ") for the global schema.", ResultCodeEnum.UNWILLING_TO_PERFORM);
        }
        String msg = "Attempt to delete non-existant entry: ";
        this.assertHasEntry(nextInterceptor, msg, name);
        boolean hasChildren = false;
        NamingEnumeration<SearchResult> list = nextInterceptor.list(new ListOperationContext(name));
        if (list.hasMore()) {
            hasChildren = true;
        }
        list.close();
        if (hasChildren) {
            LdapContextNotEmptyException e = new LdapContextNotEmptyException();
            e.setResolvedName((Name)new LdapDN(name.getUpName()));
            throw e;
        }
        LRUMap lRUMap = this.notAliasCache;
        synchronized (lRUMap) {
            if (this.notAliasCache.containsKey((Object)name.getNormName())) {
                this.notAliasCache.remove((Object)name.getNormName());
            }
        }
        nextInterceptor.delete(opContext);
    }

    public NamingEnumeration list(NextInterceptor nextInterceptor, ListOperationContext opContext) throws NamingException {
        if (opContext.getDn().getNormName().equals(this.subschemSubentryDn.getNormName())) {
            return new EmptyEnumeration();
        }
        String msg = "Attempt to search under non-existant entry: ";
        this.assertHasEntry(nextInterceptor, msg, opContext.getDn());
        return nextInterceptor.list(opContext);
    }

    @Override
    public Attributes lookup(NextInterceptor nextInterceptor, LookupOperationContext opContext) throws NamingException {
        if (opContext.getDn().getNormName().equals(this.subschemSubentryDn.getNormName())) {
            return this.nexus.getRootDSE(null);
        }
        String msg = "Attempt to lookup non-existant entry: ";
        this.assertHasEntry(nextInterceptor, msg, opContext.getDn());
        return nextInterceptor.lookup(opContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void modify(NextInterceptor nextInterceptor, ModifyOperationContext opContext) throws NamingException {
        String msg = "Attempt to modify non-existant entry: ";
        if (opContext.getDn().getNormName().equalsIgnoreCase(this.subschemSubentryDn.getNormName())) {
            nextInterceptor.modify(opContext);
            return;
        }
        this.assertHasEntry(nextInterceptor, msg, opContext.getDn());
        Attributes entry = this.nexus.lookup(new LookupOperationContext(opContext.getDn()));
        ModificationItemImpl[] items = opContext.getModItems();
        for (int ii = 0; ii < items.length; ++ii) {
            Attribute modAttr;
            Attribute entryAttr;
            if (items[ii].getModificationOp() != 1 || (entryAttr = entry.get((modAttr = items[ii].getAttribute()).getID())) == null) continue;
            for (int jj = 0; jj < modAttr.size(); ++jj) {
                if (!entryAttr.contains(modAttr.get(jj))) continue;
                throw new LdapAttributeInUseException("Trying to add existing value '" + modAttr.get(jj) + "' to attribute " + modAttr.getID());
            }
        }
        LRUMap lRUMap = this.notAliasCache;
        synchronized (lRUMap) {
            if (this.notAliasCache.containsKey((Object)opContext.getDn().getNormName())) {
                this.notAliasCache.remove((Object)opContext.getDn().getNormName());
            }
        }
        nextInterceptor.modify(opContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rename(NextInterceptor nextInterceptor, RenameOperationContext opContext) throws NamingException {
        LdapDN dn = opContext.getDn();
        if (dn.getNormName().equalsIgnoreCase(this.subschemSubentryDn.getNormName())) {
            throw new LdapOperationNotSupportedException("Can not allow the renaming of the subschemaSubentry (" + this.subschemSubentryDn + ") for the global schema: it is fixed at " + this.subschemSubentryDn, ResultCodeEnum.UNWILLING_TO_PERFORM);
        }
        String msg = "Attempt to rename non-existant entry: ";
        this.assertHasEntry(nextInterceptor, msg, dn);
        LdapDN newDn = (LdapDN)dn.clone();
        newDn.remove(dn.size() - 1);
        newDn.add(opContext.getNewRdn());
        newDn.normalize(this.normalizerMap);
        if (nextInterceptor.hasEntry(new EntryOperationContext(newDn))) {
            LdapNameAlreadyBoundException e = new LdapNameAlreadyBoundException("target entry " + newDn.getUpName() + " already exists!");
            e.setResolvedName((Name)new LdapDN(newDn.getUpName()));
            throw e;
        }
        LRUMap lRUMap = this.notAliasCache;
        synchronized (lRUMap) {
            if (this.notAliasCache.containsKey((Object)dn.getNormName())) {
                this.notAliasCache.remove((Object)dn.getNormName());
            }
        }
        nextInterceptor.rename(opContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void move(NextInterceptor nextInterceptor, MoveOperationContext opContext) throws NamingException {
        LdapDN oriChildName = opContext.getDn();
        LdapDN newParentName = opContext.getParent();
        if (oriChildName.getNormName().equalsIgnoreCase(this.subschemSubentryDn.getNormName())) {
            throw new LdapOperationNotSupportedException("Can not allow the move of the subschemaSubentry (" + this.subschemSubentryDn + ") for the global schema: it is fixed at " + this.subschemSubentryDn, ResultCodeEnum.UNWILLING_TO_PERFORM);
        }
        String msg = "Attempt to move to non-existant parent: ";
        this.assertHasEntry(nextInterceptor, msg, oriChildName);
        msg = "Attempt to move to non-existant parent: ";
        this.assertHasEntry(nextInterceptor, msg, newParentName);
        String rdn = oriChildName.get(oriChildName.size() - 1);
        LdapDN target = (LdapDN)newParentName.clone();
        target.add(rdn);
        if (nextInterceptor.hasEntry(new EntryOperationContext(target))) {
            String upRdn = new LdapDN(oriChildName.getUpName()).get(oriChildName.size() - 1);
            LdapDN upTarget = (LdapDN)newParentName.clone();
            upTarget.add(upRdn);
            LdapNameAlreadyBoundException e = new LdapNameAlreadyBoundException("target entry " + upTarget.getUpName() + " already exists!");
            e.setResolvedName((Name)new LdapDN(upTarget.getUpName()));
            throw e;
        }
        LRUMap lRUMap = this.notAliasCache;
        synchronized (lRUMap) {
            if (this.notAliasCache.containsKey((Object)oriChildName.getNormName())) {
                this.notAliasCache.remove((Object)oriChildName.getNormName());
            }
        }
        nextInterceptor.move(opContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void moveAndRename(NextInterceptor nextInterceptor, MoveAndRenameOperationContext opContext) throws NamingException {
        LdapDN oriChildName = opContext.getDn();
        LdapDN parent = opContext.getParent();
        String newRn = opContext.getNewRdn();
        if (oriChildName.getNormName().equalsIgnoreCase(this.subschemSubentryDn.getNormName())) {
            throw new LdapOperationNotSupportedException("Can not allow the move of the subschemaSubentry (" + this.subschemSubentryDn + ") for the global schema: it is fixed at " + this.subschemSubentryDn, ResultCodeEnum.UNWILLING_TO_PERFORM);
        }
        String msg = "Attempt to move to non-existant parent: ";
        this.assertHasEntry(nextInterceptor, msg, oriChildName);
        msg = "Attempt to move to non-existant parent: ";
        this.assertHasEntry(nextInterceptor, msg, parent);
        LdapDN target = (LdapDN)parent.clone();
        target.add(newRn);
        target.normalize(this.normalizerMap);
        if (nextInterceptor.hasEntry(new EntryOperationContext(target))) {
            LdapDN upTarget = (LdapDN)parent.clone();
            upTarget.add(newRn);
            LdapNameAlreadyBoundException e = new LdapNameAlreadyBoundException("target entry " + upTarget.getUpName() + " already exists!");
            e.setResolvedName((Name)new LdapDN(upTarget.getUpName()));
            throw e;
        }
        LRUMap lRUMap = this.notAliasCache;
        synchronized (lRUMap) {
            if (this.notAliasCache.containsKey((Object)oriChildName.getNormName())) {
                this.notAliasCache.remove((Object)oriChildName.getNormName());
            }
        }
        nextInterceptor.moveAndRename(opContext);
    }

    @Override
    public NamingEnumeration<SearchResult> search(NextInterceptor nextInterceptor, SearchOperationContext opContext) throws NamingException {
        LdapDN base = opContext.getDn();
        try {
            NamingEnumeration<SearchResult> result = nextInterceptor.search(opContext);
            if (!(result.hasMoreElements() || base.isEmpty() || this.subschemSubentryDn.toNormName().equalsIgnoreCase(base.toNormName()))) {
                this.assertHasEntry(nextInterceptor, "Attempt to search under non-existant entry:", base);
            }
            return result;
        }
        catch (NamingException ne) {
            String msg = "Attempt to search under non-existant entry: ";
            this.assertHasEntry(nextInterceptor, msg, base);
            throw ne;
        }
    }

    private void assertHasEntry(NextInterceptor nextInterceptor, String msg, LdapDN dn) throws NamingException {
        if (this.subschemSubentryDn.getNormName().equals(dn.getNormName())) {
            return;
        }
        Invocation invocation = InvocationStack.getInstance().peek();
        PartitionNexusProxy proxy = invocation.getProxy();
        if (!nextInterceptor.hasEntry(new EntryOperationContext(dn))) {
            LdapNameNotFoundException e = msg != null ? new LdapNameNotFoundException(msg + dn) : new LdapNameNotFoundException(dn.toString());
            e.setResolvedName((Name)new LdapDN(proxy.getMatchedName(new GetMatchedNameOperationContext(dn)).getUpName()));
            throw e;
        }
    }
}

