/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.jndi;

import java.util.Hashtable;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.ldap.Control;
import javax.naming.ldap.ExtendedRequest;
import javax.naming.ldap.ExtendedResponse;
import javax.naming.ldap.LdapContext;
import org.apache.directory.server.core.DirectoryService;
import org.apache.directory.server.core.authn.LdapPrincipal;
import org.apache.directory.server.core.interceptor.context.CompareOperationContext;
import org.apache.directory.server.core.interceptor.context.UnbindOperationContext;
import org.apache.directory.server.core.jndi.ServerContext;
import org.apache.directory.server.core.jndi.ServerDirContext;
import org.apache.directory.server.core.referral.ReferralService;
import org.apache.directory.shared.ldap.NotImplementedException;
import org.apache.directory.shared.ldap.name.LdapDN;

public class ServerLdapContext
extends ServerDirContext
implements LdapContext {
    private transient ReferralService refService = null;

    public ServerLdapContext(DirectoryService service, Hashtable env) throws NamingException {
        super(service, env);
        this.refService = (ReferralService)service.getConfiguration().getInterceptorChain().get("referralService");
    }

    ServerLdapContext(DirectoryService service, LdapPrincipal principal, LdapDN dn) throws NamingException {
        super(service, principal, (Name)dn);
        this.refService = (ReferralService)service.getConfiguration().getInterceptorChain().get("referralService");
    }

    public ExtendedResponse extendedOperation(ExtendedRequest request) {
        throw new NotImplementedException();
    }

    public LdapContext newInstance(Control[] requestControls) throws NamingException {
        ServerLdapContext ctx = new ServerLdapContext(this.getService(), this.getPrincipal(), (LdapDN)this.getDn());
        ctx.setRequestControls(requestControls);
        return ctx;
    }

    public void reconnect(Control[] connCtls) throws NamingException {
        this.connectControls = connCtls;
    }

    public Control[] getConnectControls() throws NamingException {
        return this.connectControls;
    }

    public void setRequestControls(Control[] requestControls) throws NamingException {
        this.requestControls = requestControls;
    }

    public Control[] getRequestControls() throws NamingException {
        return this.requestControls;
    }

    public Control[] getResponseControls() throws NamingException {
        return this.responseControls;
    }

    public boolean compare(LdapDN name, String oid, Object value) throws NamingException {
        CompareOperationContext opCtx = new CompareOperationContext(name, oid, value);
        opCtx.addRequestControls(this.requestControls);
        boolean result = super.getNexusProxy().compare(opCtx);
        this.responseControls = this.getResponseControls();
        this.requestControls = EMPTY_CONTROLS;
        return result;
    }

    public void ldapUnbind() throws NamingException {
        LdapDN principalDn = null;
        Object principalDnValue = this.getEnvironment().get("java.naming.security.principal");
        if (principalDnValue instanceof LdapDN) {
            principalDn = (LdapDN)principalDnValue;
        } else {
            String bindDn = (String)principalDnValue;
            principalDn = new LdapDN(bindDn);
        }
        UnbindOperationContext opCtx = new UnbindOperationContext(principalDn);
        opCtx.addRequestControls(this.requestControls);
        super.getNexusProxy().unbind(opCtx);
        this.responseControls = opCtx.getResponseControls();
        this.requestControls = EMPTY_CONTROLS;
    }

    public boolean isReferral(String name) throws NamingException {
        return this.refService.isReferral(name);
    }

    public boolean isReferral(LdapDN name) throws NamingException {
        return this.refService.isReferral(name);
    }

    public ServerContext getRootContext() throws NamingException {
        return new ServerLdapContext(this.getService(), this.getPrincipal(), new LdapDN());
    }
}

