/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.trigger;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.naming.Name;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import org.apache.directory.server.core.DirectoryServiceConfiguration;
import org.apache.directory.server.core.configuration.InterceptorConfiguration;
import org.apache.directory.server.core.interceptor.BaseInterceptor;
import org.apache.directory.server.core.interceptor.InterceptorChain;
import org.apache.directory.server.core.interceptor.NextInterceptor;
import org.apache.directory.server.core.interceptor.context.AddOperationContext;
import org.apache.directory.server.core.interceptor.context.DeleteOperationContext;
import org.apache.directory.server.core.interceptor.context.LookupOperationContext;
import org.apache.directory.server.core.interceptor.context.ModifyOperationContext;
import org.apache.directory.server.core.interceptor.context.MoveAndRenameOperationContext;
import org.apache.directory.server.core.interceptor.context.MoveOperationContext;
import org.apache.directory.server.core.interceptor.context.RenameOperationContext;
import org.apache.directory.server.core.invocation.Invocation;
import org.apache.directory.server.core.invocation.InvocationStack;
import org.apache.directory.server.core.jndi.ServerLdapContext;
import org.apache.directory.server.core.partition.PartitionNexusProxy;
import org.apache.directory.server.core.sp.StoredProcEngine;
import org.apache.directory.server.core.sp.StoredProcEngineConfig;
import org.apache.directory.server.core.sp.StoredProcExecutionManager;
import org.apache.directory.server.core.sp.java.JavaStoredProcEngineConfig;
import org.apache.directory.server.core.subtree.SubentryService;
import org.apache.directory.server.core.trigger.AddStoredProcedureParameterInjector;
import org.apache.directory.server.core.trigger.DeleteStoredProcedureParameterInjector;
import org.apache.directory.server.core.trigger.ModifyDNStoredProcedureParameterInjector;
import org.apache.directory.server.core.trigger.ModifyStoredProcedureParameterInjector;
import org.apache.directory.server.core.trigger.SimpleTriggerExecutionAuthorizer;
import org.apache.directory.server.core.trigger.StoredProcedureParameterInjector;
import org.apache.directory.server.core.trigger.TriggerExecutionAuthorizer;
import org.apache.directory.server.core.trigger.TriggerSpecCache;
import org.apache.directory.server.schema.registries.AttributeTypeRegistry;
import org.apache.directory.shared.ldap.exception.LdapNamingException;
import org.apache.directory.shared.ldap.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.schema.NormalizerMappingResolver;
import org.apache.directory.shared.ldap.trigger.ActionTime;
import org.apache.directory.shared.ldap.trigger.LdapOperation;
import org.apache.directory.shared.ldap.trigger.TriggerSpecification;
import org.apache.directory.shared.ldap.trigger.TriggerSpecificationParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TriggerService
extends BaseInterceptor {
    private static final Logger log = LoggerFactory.getLogger(TriggerService.class);
    private static final String ENTRY_TRIGGER_ATTR = "entryTriggerSpecification";
    private TriggerSpecCache triggerSpecCache;
    private TriggerSpecificationParser triggerParser;
    private AttributeTypeRegistry attrRegistry;
    private InterceptorChain chain;
    private boolean enabled = true;
    private TriggerExecutionAuthorizer triggerExecutionAuthorizer = new SimpleTriggerExecutionAuthorizer();
    private StoredProcExecutionManager manager;

    private void addPrescriptiveTriggerSpecs(List<TriggerSpecification> triggerSpecs, PartitionNexusProxy proxy, LdapDN dn, Attributes entry) throws NamingException {
        Attribute subentries;
        if (entry.get("objectClass").contains("subentry")) {
            LdapDN parentDn = (LdapDN)dn.clone();
            parentDn.remove(dn.size() - 1);
            entry = proxy.lookup(new LookupOperationContext(parentDn), PartitionNexusProxy.LOOKUP_BYPASS);
        }
        if ((subentries = entry.get("triggerExecutionSubentries")) == null) {
            return;
        }
        for (int ii = 0; ii < subentries.size(); ++ii) {
            String subentryDn = (String)subentries.get(ii);
            triggerSpecs.addAll(this.triggerSpecCache.getSubentryTriggerSpecs(subentryDn));
        }
    }

    private void addEntryTriggerSpecs(List<TriggerSpecification> triggerSpecs, Attributes entry) throws NamingException {
        Attribute entryTrigger = entry.get(ENTRY_TRIGGER_ATTR);
        if (entryTrigger == null) {
            return;
        }
        for (int ii = 0; ii < entryTrigger.size(); ++ii) {
            TriggerSpecification item;
            String triggerString = (String)entryTrigger.get(ii);
            try {
                item = this.triggerParser.parse(triggerString);
            }
            catch (ParseException e) {
                String msg = "failed to parse entryTrigger: " + triggerString;
                log.error(msg, (Throwable)e);
                throw new LdapNamingException(msg, ResultCodeEnum.OPERATIONS_ERROR);
            }
            triggerSpecs.add(item);
        }
    }

    public Map<ActionTime, List<TriggerSpecification>> getActionTimeMappedTriggerSpecsForOperation(List<TriggerSpecification> triggerSpecs, LdapOperation ldapOperation) {
        ArrayList<TriggerSpecification> afterTriggerSpecs = new ArrayList<TriggerSpecification>();
        HashMap<ActionTime, List<TriggerSpecification>> triggerSpecMap = new HashMap<ActionTime, List<TriggerSpecification>>();
        for (TriggerSpecification triggerSpec : triggerSpecs) {
            if (!triggerSpec.getLdapOperation().equals((Object)ldapOperation) || !triggerSpec.getActionTime().equals((Object)ActionTime.AFTER)) continue;
            afterTriggerSpecs.add(triggerSpec);
        }
        triggerSpecMap.put(ActionTime.AFTER, afterTriggerSpecs);
        return triggerSpecMap;
    }

    @Override
    public void init(DirectoryServiceConfiguration dirServCfg, InterceptorConfiguration intCfg) throws NamingException {
        super.init(dirServCfg, intCfg);
        this.triggerSpecCache = new TriggerSpecCache(dirServCfg);
        this.attrRegistry = dirServCfg.getRegistries().getAttributeTypeRegistry();
        this.triggerParser = new TriggerSpecificationParser(new NormalizerMappingResolver(){

            public Map getNormalizerMapping() throws NamingException {
                return TriggerService.this.attrRegistry.getNormalizerMapping();
            }
        });
        this.chain = dirServCfg.getInterceptorChain();
        JavaStoredProcEngineConfig javaSPEngineConfig = new JavaStoredProcEngineConfig();
        ArrayList<StoredProcEngineConfig> spEngineConfigs = new ArrayList<StoredProcEngineConfig>();
        spEngineConfigs.add(javaSPEngineConfig);
        String spContainer = "ou=Stored Procedures,ou=system";
        this.manager = new StoredProcExecutionManager(spContainer, spEngineConfigs);
        this.enabled = true;
    }

    @Override
    public void add(NextInterceptor next, AddOperationContext addContext) throws NamingException {
        LdapDN name = addContext.getDn();
        Attributes entry = addContext.getEntry();
        if (!this.enabled) {
            next.add(addContext);
            return;
        }
        Invocation invocation = InvocationStack.getInstance().peek();
        PartitionNexusProxy proxy = invocation.getProxy();
        ServerLdapContext callerRootCtx = (ServerLdapContext)((ServerLdapContext)invocation.getCaller()).getRootContext();
        AddStoredProcedureParameterInjector injector = new AddStoredProcedureParameterInjector(invocation, name, entry);
        ArrayList<TriggerSpecification> triggerSpecs = new ArrayList<TriggerSpecification>();
        this.addPrescriptiveTriggerSpecs(triggerSpecs, proxy, name, entry);
        Map<ActionTime, List<TriggerSpecification>> triggerMap = this.getActionTimeMappedTriggerSpecsForOperation(triggerSpecs, LdapOperation.ADD);
        next.add(addContext);
        this.triggerSpecCache.subentryAdded(name, entry);
        List<TriggerSpecification> afterTriggerSpecs = triggerMap.get(ActionTime.AFTER);
        this.executeTriggers(afterTriggerSpecs, injector, callerRootCtx);
    }

    @Override
    public void delete(NextInterceptor next, DeleteOperationContext deleteContext) throws NamingException {
        LdapDN name = deleteContext.getDn();
        if (!this.enabled) {
            next.delete(deleteContext);
            return;
        }
        Invocation invocation = InvocationStack.getInstance().peek();
        PartitionNexusProxy proxy = invocation.getProxy();
        Attributes deletedEntry = proxy.lookup(new LookupOperationContext(name), PartitionNexusProxy.LOOKUP_BYPASS);
        ServerLdapContext callerRootCtx = (ServerLdapContext)((ServerLdapContext)invocation.getCaller()).getRootContext();
        DeleteStoredProcedureParameterInjector injector = new DeleteStoredProcedureParameterInjector(invocation, name);
        ArrayList<TriggerSpecification> triggerSpecs = new ArrayList<TriggerSpecification>();
        this.addPrescriptiveTriggerSpecs(triggerSpecs, proxy, name, deletedEntry);
        this.addEntryTriggerSpecs(triggerSpecs, deletedEntry);
        Map<ActionTime, List<TriggerSpecification>> triggerMap = this.getActionTimeMappedTriggerSpecsForOperation(triggerSpecs, LdapOperation.DELETE);
        next.delete(deleteContext);
        this.triggerSpecCache.subentryDeleted(name, deletedEntry);
        List<TriggerSpecification> afterTriggerSpecs = triggerMap.get(ActionTime.AFTER);
        this.executeTriggers(afterTriggerSpecs, injector, callerRootCtx);
    }

    @Override
    public void modify(NextInterceptor next, ModifyOperationContext opContext) throws NamingException {
        if (!this.enabled) {
            next.modify(opContext);
            return;
        }
        LdapDN normName = opContext.getDn();
        Invocation invocation = InvocationStack.getInstance().peek();
        PartitionNexusProxy proxy = invocation.getProxy();
        Attributes modifiedEntry = proxy.lookup(new LookupOperationContext(normName), PartitionNexusProxy.LOOKUP_BYPASS);
        ServerLdapContext callerRootCtx = (ServerLdapContext)((ServerLdapContext)invocation.getCaller()).getRootContext();
        ModifyStoredProcedureParameterInjector injector = new ModifyStoredProcedureParameterInjector(invocation, opContext);
        ArrayList<TriggerSpecification> triggerSpecs = new ArrayList<TriggerSpecification>();
        this.addPrescriptiveTriggerSpecs(triggerSpecs, proxy, normName, modifiedEntry);
        this.addEntryTriggerSpecs(triggerSpecs, modifiedEntry);
        Map<ActionTime, List<TriggerSpecification>> triggerMap = this.getActionTimeMappedTriggerSpecsForOperation(triggerSpecs, LdapOperation.MODIFY);
        next.modify(opContext);
        this.triggerSpecCache.subentryModified(opContext, modifiedEntry);
        List<TriggerSpecification> afterTriggerSpecs = triggerMap.get(ActionTime.AFTER);
        this.executeTriggers(afterTriggerSpecs, injector, callerRootCtx);
    }

    @Override
    public void rename(NextInterceptor next, RenameOperationContext renameContext) throws NamingException {
        LdapDN name = renameContext.getDn();
        String newRdn = renameContext.getNewRdn();
        boolean deleteOldRn = renameContext.getDelOldDn();
        if (!this.enabled) {
            next.rename(renameContext);
            return;
        }
        Invocation invocation = InvocationStack.getInstance().peek();
        PartitionNexusProxy proxy = invocation.getProxy();
        Attributes renamedEntry = proxy.lookup(new LookupOperationContext(name), PartitionNexusProxy.LOOKUP_BYPASS);
        ServerLdapContext callerRootCtx = (ServerLdapContext)((ServerLdapContext)invocation.getCaller()).getRootContext();
        LdapDN oldRDN = new LdapDN(name.getRdn().getUpName());
        LdapDN newRDN = new LdapDN(newRdn);
        LdapDN oldSuperiorDN = (LdapDN)name.clone();
        oldSuperiorDN.remove(oldSuperiorDN.size() - 1);
        LdapDN newSuperiorDN = (LdapDN)oldSuperiorDN.clone();
        LdapDN oldDN = (LdapDN)name.clone();
        LdapDN newDN = (LdapDN)name.clone();
        newDN.add(newRdn);
        ModifyDNStoredProcedureParameterInjector injector = new ModifyDNStoredProcedureParameterInjector(invocation, deleteOldRn, oldRDN, newRDN, oldSuperiorDN, newSuperiorDN, oldDN, newDN);
        ArrayList<TriggerSpecification> triggerSpecs = new ArrayList<TriggerSpecification>();
        this.addPrescriptiveTriggerSpecs(triggerSpecs, proxy, name, renamedEntry);
        this.addEntryTriggerSpecs(triggerSpecs, renamedEntry);
        Map<ActionTime, List<TriggerSpecification>> triggerMap = this.getActionTimeMappedTriggerSpecsForOperation(triggerSpecs, LdapOperation.MODIFYDN_RENAME);
        next.rename(renameContext);
        this.triggerSpecCache.subentryRenamed(name, newDN);
        List<TriggerSpecification> afterTriggerSpecs = triggerMap.get(ActionTime.AFTER);
        this.executeTriggers(afterTriggerSpecs, injector, callerRootCtx);
    }

    @Override
    public void moveAndRename(NextInterceptor next, MoveAndRenameOperationContext moveAndRenameContext) throws NamingException {
        LdapDN oriChildName = moveAndRenameContext.getDn();
        LdapDN parent = moveAndRenameContext.getParent();
        String newRn = moveAndRenameContext.getNewRdn();
        boolean deleteOldRn = moveAndRenameContext.getDelOldDn();
        if (!this.enabled) {
            next.moveAndRename(moveAndRenameContext);
            return;
        }
        Invocation invocation = InvocationStack.getInstance().peek();
        PartitionNexusProxy proxy = invocation.getProxy();
        Attributes movedEntry = proxy.lookup(new LookupOperationContext(oriChildName), PartitionNexusProxy.LOOKUP_BYPASS);
        ServerLdapContext callerRootCtx = (ServerLdapContext)((ServerLdapContext)invocation.getCaller()).getRootContext();
        LdapDN oldRDN = new LdapDN(oriChildName.getRdn().getUpName());
        LdapDN newRDN = new LdapDN(newRn);
        LdapDN oldSuperiorDN = (LdapDN)oriChildName.clone();
        oldSuperiorDN.remove(oldSuperiorDN.size() - 1);
        LdapDN newSuperiorDN = (LdapDN)parent.clone();
        LdapDN oldDN = (LdapDN)oriChildName.clone();
        LdapDN newDN = (LdapDN)parent.clone();
        newDN.add(newRn);
        ModifyDNStoredProcedureParameterInjector injector = new ModifyDNStoredProcedureParameterInjector(invocation, deleteOldRn, oldRDN, newRDN, oldSuperiorDN, newSuperiorDN, oldDN, newDN);
        ArrayList<TriggerSpecification> exportTriggerSpecs = new ArrayList<TriggerSpecification>();
        this.addPrescriptiveTriggerSpecs(exportTriggerSpecs, proxy, oriChildName, movedEntry);
        this.addEntryTriggerSpecs(exportTriggerSpecs, movedEntry);
        Attributes importedEntry = proxy.lookup(new LookupOperationContext(oriChildName), PartitionNexusProxy.LOOKUP_EXCLUDING_OPR_ATTRS_BYPASS);
        SubentryService subentryService = (SubentryService)this.chain.get("subentryService");
        Attributes fakeImportedEntry = subentryService.getSubentryAttributes((Name)newDN, importedEntry);
        NamingEnumeration<? extends Attribute> attrList = importedEntry.getAll();
        while (attrList.hasMore()) {
            fakeImportedEntry.put(attrList.next());
        }
        ArrayList<TriggerSpecification> importTriggerSpecs = new ArrayList<TriggerSpecification>();
        this.addPrescriptiveTriggerSpecs(importTriggerSpecs, proxy, newDN, fakeImportedEntry);
        Map<ActionTime, List<TriggerSpecification>> exportTriggerMap = this.getActionTimeMappedTriggerSpecsForOperation(exportTriggerSpecs, LdapOperation.MODIFYDN_EXPORT);
        Map<ActionTime, List<TriggerSpecification>> importTriggerMap = this.getActionTimeMappedTriggerSpecsForOperation(importTriggerSpecs, LdapOperation.MODIFYDN_IMPORT);
        next.moveAndRename(moveAndRenameContext);
        this.triggerSpecCache.subentryRenamed(oldDN, newDN);
        List<TriggerSpecification> afterExportTriggerSpecs = exportTriggerMap.get(ActionTime.AFTER);
        List<TriggerSpecification> afterImportTriggerSpecs = importTriggerMap.get(ActionTime.AFTER);
        this.executeTriggers(afterExportTriggerSpecs, injector, callerRootCtx);
        this.executeTriggers(afterImportTriggerSpecs, injector, callerRootCtx);
    }

    @Override
    public void move(NextInterceptor next, MoveOperationContext moveContext) throws NamingException {
        if (!this.enabled) {
            next.move(moveContext);
            return;
        }
        LdapDN oriChildName = moveContext.getDn();
        LdapDN newParentName = moveContext.getParent();
        Invocation invocation = InvocationStack.getInstance().peek();
        PartitionNexusProxy proxy = invocation.getProxy();
        Attributes movedEntry = proxy.lookup(new LookupOperationContext(oriChildName), PartitionNexusProxy.LOOKUP_BYPASS);
        ServerLdapContext callerRootCtx = (ServerLdapContext)((ServerLdapContext)invocation.getCaller()).getRootContext();
        LdapDN oldRDN = new LdapDN(oriChildName.getRdn().getUpName());
        LdapDN newRDN = new LdapDN(oriChildName.getRdn().getUpName());
        LdapDN oldSuperiorDN = (LdapDN)oriChildName.clone();
        oldSuperiorDN.remove(oldSuperiorDN.size() - 1);
        LdapDN newSuperiorDN = (LdapDN)newParentName.clone();
        LdapDN oldDN = (LdapDN)oriChildName.clone();
        LdapDN newDN = (LdapDN)newParentName.clone();
        newDN.add(newRDN.getUpName());
        ModifyDNStoredProcedureParameterInjector injector = new ModifyDNStoredProcedureParameterInjector(invocation, false, oldRDN, newRDN, oldSuperiorDN, newSuperiorDN, oldDN, newDN);
        ArrayList<TriggerSpecification> exportTriggerSpecs = new ArrayList<TriggerSpecification>();
        this.addPrescriptiveTriggerSpecs(exportTriggerSpecs, proxy, oriChildName, movedEntry);
        this.addEntryTriggerSpecs(exportTriggerSpecs, movedEntry);
        Attributes importedEntry = proxy.lookup(new LookupOperationContext(oriChildName), PartitionNexusProxy.LOOKUP_EXCLUDING_OPR_ATTRS_BYPASS);
        SubentryService subentryService = (SubentryService)this.chain.get("subentryService");
        Attributes fakeImportedEntry = subentryService.getSubentryAttributes((Name)newDN, importedEntry);
        NamingEnumeration<? extends Attribute> attrList = importedEntry.getAll();
        while (attrList.hasMore()) {
            fakeImportedEntry.put(attrList.next());
        }
        ArrayList<TriggerSpecification> importTriggerSpecs = new ArrayList<TriggerSpecification>();
        this.addPrescriptiveTriggerSpecs(importTriggerSpecs, proxy, newDN, fakeImportedEntry);
        Map<ActionTime, List<TriggerSpecification>> exportTriggerMap = this.getActionTimeMappedTriggerSpecsForOperation(exportTriggerSpecs, LdapOperation.MODIFYDN_EXPORT);
        Map<ActionTime, List<TriggerSpecification>> importTriggerMap = this.getActionTimeMappedTriggerSpecsForOperation(importTriggerSpecs, LdapOperation.MODIFYDN_IMPORT);
        next.move(moveContext);
        this.triggerSpecCache.subentryRenamed(oldDN, newDN);
        List<TriggerSpecification> afterExportTriggerSpecs = exportTriggerMap.get(ActionTime.AFTER);
        List<TriggerSpecification> afterImportTriggerSpecs = importTriggerMap.get(ActionTime.AFTER);
        this.executeTriggers(afterExportTriggerSpecs, injector, callerRootCtx);
        this.executeTriggers(afterImportTriggerSpecs, injector, callerRootCtx);
    }

    private Object executeTriggers(List<TriggerSpecification> triggerSpecs, StoredProcedureParameterInjector injector, ServerLdapContext callerRootCtx) throws NamingException {
        Object result = null;
        for (TriggerSpecification tsec : triggerSpecs) {
            if (!this.triggerExecutionAuthorizer.hasPermission()) continue;
            result = this.executeTrigger(tsec, injector, callerRootCtx);
        }
        return result;
    }

    private Object executeTrigger(TriggerSpecification tsec, StoredProcedureParameterInjector injector, ServerLdapContext callerRootCtx) throws NamingException {
        ArrayList<Object> returnValues = new ArrayList<Object>();
        List spSpecs = tsec.getSPSpecs();
        for (TriggerSpecification.SPSpec spSpec : spSpecs) {
            ArrayList<Object> arguments = new ArrayList<Object>();
            arguments.addAll(injector.getArgumentsToInject(spSpec.getParameters()));
            Object[] values = arguments.toArray();
            Object returnValue = this.executeProcedure(callerRootCtx, spSpec.getName(), values);
            returnValues.add(returnValue);
        }
        return returnValues;
    }

    private Object executeProcedure(ServerLdapContext ctx, String procedure, Object[] values) throws NamingException {
        try {
            Attributes spUnit = this.manager.findStoredProcUnit(ctx, procedure);
            StoredProcEngine engine = this.manager.getStoredProcEngineInstance(spUnit);
            return engine.invokeProcedure(ctx, procedure, values);
        }
        catch (NamingException e) {
            LdapNamingException lne = new LdapNamingException(ResultCodeEnum.OTHER);
            lne.setRootCause((Throwable)e);
            throw lne;
        }
    }
}

