/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.task.providers;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang.LocaleUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientRuntimeException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.platform.query.api.AbstractPageProvider;
import org.nuxeo.ecm.platform.query.api.PageProvider;
import org.nuxeo.ecm.platform.task.Task;
import org.nuxeo.ecm.platform.task.TaskService;
import org.nuxeo.ecm.platform.task.dashboard.DashBoardItem;
import org.nuxeo.ecm.platform.task.dashboard.DashBoardItemImpl;
import org.nuxeo.runtime.api.Framework;

public class UserTaskPageProvider
extends AbstractPageProvider<DashBoardItem>
implements PageProvider<DashBoardItem> {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(UserTaskPageProvider.class);
    public static final String CORE_SESSION_PROPERTY = "coreSession";
    public static final String FILTER_DOCS_FROM_TRASH = "filterDocumentsFromTrash";
    protected List<DashBoardItem> userTasks;
    protected List<DashBoardItem> pageTasks;

    public List<DashBoardItem> getCurrentPage() {
        if (this.pageTasks == null) {
            this.pageTasks = new ArrayList<DashBoardItem>();
            if (this.userTasks == null) {
                this.getAllTasks();
            }
            if (!this.hasError()) {
                long resultsCount = this.userTasks.size();
                this.setResultsCount(resultsCount);
                long pageSize = this.getMinMaxPageSize();
                if (pageSize == 0L) {
                    this.pageTasks.addAll(this.userTasks);
                } else {
                    long offset = this.getCurrentPageOffset();
                    if (offset <= resultsCount) {
                        int i = Long.valueOf(offset).intValue();
                        while ((long)i < resultsCount && (long)i < offset + pageSize) {
                            this.pageTasks.add(this.userTasks.get(i));
                            ++i;
                        }
                    }
                }
            }
        }
        return this.pageTasks;
    }

    protected Locale getLocale() {
        String locale = (String)this.getProperties().get("locale");
        if (!StringUtils.isBlank((String)locale)) {
            return LocaleUtils.toLocale((String)locale);
        }
        return Locale.getDefault();
    }

    protected void getAllTasks() {
        this.error = null;
        this.errorMessage = null;
        this.userTasks = new ArrayList<DashBoardItem>();
        try {
            CoreSession coreSession = this.getCoreSession();
            boolean filterTrashDocs = this.getFilterDocumentsInTrash();
            NuxeoPrincipal pal = (NuxeoPrincipal)coreSession.getPrincipal();
            TaskService taskService = (TaskService)Framework.getService(TaskService.class);
            List<Task> tasks = taskService.getAllCurrentTaskInstances(coreSession, this.getSortInfos());
            if (tasks != null) {
                for (Task task : tasks) {
                    try {
                        if (task.hasEnded().booleanValue() || task.isCancelled().booleanValue()) continue;
                        DocumentModel doc = taskService.getTargetDocumentModel(task, coreSession);
                        if (doc != null) {
                            if (filterTrashDocs && "deleted".equals(doc.getCurrentLifeCycleState())) continue;
                            this.userTasks.add(new DashBoardItemImpl(task, doc, this.getLocale()));
                            continue;
                        }
                        log.warn((Object)String.format("User '%s' has a task of type '%s' on a missing or deleted document", pal.getName(), task.getName()));
                    }
                    catch (Exception e) {
                        log.error((Object)e);
                    }
                }
            }
        }
        catch (Exception e) {
            this.error = e;
            this.errorMessage = e.getMessage();
            log.warn((Object)e.getMessage(), (Throwable)e);
        }
    }

    protected boolean getFilterDocumentsInTrash() {
        Map props = this.getProperties();
        if (props.containsKey(FILTER_DOCS_FROM_TRASH)) {
            return Boolean.TRUE.equals(Boolean.valueOf((String)props.get(FILTER_DOCS_FROM_TRASH)));
        }
        return true;
    }

    protected CoreSession getCoreSession() {
        Map props = this.getProperties();
        CoreSession coreSession = (CoreSession)props.get(CORE_SESSION_PROPERTY);
        if (coreSession == null) {
            throw new ClientRuntimeException("cannot find core session");
        }
        return coreSession;
    }

    public boolean isSortable() {
        return false;
    }

    protected void pageChanged() {
        this.pageTasks = null;
        super.pageChanged();
    }

    public void refresh() {
        this.userTasks = null;
        this.pageTasks = null;
        super.refresh();
    }
}

