/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.component;

import java.io.IOException;
import java.io.Serializable;
import javax.el.ValueExpression;
import javax.faces.component.UIComponent;
import javax.faces.component.UIComponentBase;
import javax.faces.component.visit.VisitCallback;
import javax.faces.component.visit.VisitContext;
import javax.faces.component.visit.VisitResult;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.FacesEvent;
import javax.faces.event.PhaseId;
import org.ajax4jsf.component.IterationStateHolder;
import org.richfaces.cdk.annotations.Attribute;
import org.richfaces.cdk.annotations.EventName;
import org.richfaces.component.AbstractTree;
import org.richfaces.component.MetaComponentEncoder;
import org.richfaces.component.MetaComponentResolver;
import org.richfaces.component.attribute.CoreProps;
import org.richfaces.component.attribute.EventsKeyProps;
import org.richfaces.component.attribute.EventsMouseProps;
import org.richfaces.component.attribute.I18nProps;
import org.richfaces.component.attribute.ImmediateProps;
import org.richfaces.component.attribute.TreeCommonProps;
import org.richfaces.component.attribute.TreeProps;
import org.richfaces.context.ExtendedVisitContext;
import org.richfaces.context.ExtendedVisitContextMode;
import org.richfaces.event.TreeToggleEvent;
import org.richfaces.event.TreeToggleListener;
import org.richfaces.event.TreeToggleSource;
import org.richfaces.renderkit.MetaComponentRenderer;

public abstract class AbstractTreeNode
extends UIComponentBase
implements MetaComponentResolver,
MetaComponentEncoder,
IterationStateHolder,
TreeToggleSource,
CoreProps,
EventsKeyProps,
EventsMouseProps,
ImmediateProps,
I18nProps,
TreeProps,
TreeCommonProps {
    public static final String COMPONENT_TYPE = "org.richfaces.TreeNode";
    public static final String COMPONENT_FAMILY = "org.richfaces.TreeNode";
    public static final String SUBTREE_META_COMPONENT_ID = "subtree";

    public AbstractTreeNode() {
        this.setRendererType("org.richfaces.TreeNodeRenderer");
    }

    public String getFamily() {
        return "org.richfaces.TreeNode";
    }

    @Attribute
    public abstract boolean isImmediate();

    @Attribute
    public abstract String getType();

    @Attribute(events={@EventName(value="toggle")})
    public abstract String getOntoggle();

    @Attribute(events={@EventName(value="beforetoggle")})
    public abstract String getOnbeforetoggle();

    protected Boolean getLocalExpandedValue(FacesContext facesContext) {
        return (Boolean)this.getStateHelper().get((Serializable)((Object)PropertyKeys.expanded));
    }

    @Attribute
    public boolean isExpanded() {
        FacesContext context = this.getFacesContext();
        Boolean localExpandedValue = this.getLocalExpandedValue(context);
        if (localExpandedValue != null) {
            return localExpandedValue;
        }
        ValueExpression ve = this.getValueExpression(PropertyKeys.expanded.toString());
        if (ve != null) {
            return Boolean.TRUE.equals(ve.getValue(context.getELContext()));
        }
        return false;
    }

    public void setExpanded(boolean newValue) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.expanded), (Object)newValue);
    }

    public Object getIterationState() {
        return this.getStateHelper().get((Serializable)((Object)PropertyKeys.expanded));
    }

    public void setIterationState(Object state) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.expanded), state);
    }

    public AbstractTree findTreeComponent() {
        AbstractTreeNode c;
        for (c = this; c != null && !(c instanceof AbstractTree); c = c.getParent()) {
        }
        return (AbstractTree)((Object)c);
    }

    public void queueEvent(FacesEvent event) {
        if (this.equals(event.getComponent()) && event instanceof TreeToggleEvent) {
            PhaseId targetPhase = this.isImmediate() || this.findTreeComponent().isImmediate() ? PhaseId.APPLY_REQUEST_VALUES : PhaseId.PROCESS_VALIDATIONS;
            event.setPhaseId(targetPhase);
        }
        super.queueEvent(event);
    }

    public void broadcast(FacesEvent event) throws AbortProcessingException {
        super.broadcast(event);
        if (event instanceof TreeToggleEvent) {
            TreeToggleEvent toggleEvent = (TreeToggleEvent)event;
            new TreeToggleEvent((UIComponent)this.findTreeComponent(), toggleEvent.isExpanded()).queue();
        }
    }

    @Override
    public void addTreeToggleListener(TreeToggleListener listener) {
        this.addFacesListener(listener);
    }

    @Attribute(hidden=true)
    public TreeToggleListener[] getTreeToggleListeners() {
        return (TreeToggleListener[])this.getFacesListeners(TreeToggleListener.class);
    }

    @Override
    public void removeTreeToggleListener(TreeToggleListener listener) {
        this.removeFacesListener(listener);
    }

    public String resolveClientId(FacesContext facesContext, UIComponent contextComponent, String metaComponentId) {
        if (SUBTREE_META_COMPONENT_ID.equals(metaComponentId)) {
            return this.getClientId(facesContext) + '@' + metaComponentId;
        }
        return null;
    }

    public String substituteUnresolvedClientId(FacesContext facesContext, UIComponent contextComponent, String metaComponentId) {
        return null;
    }

    public boolean visitTree(VisitContext context, VisitCallback callback) {
        VisitResult result;
        ExtendedVisitContext extendedVisitContext;
        if (context instanceof ExtendedVisitContext && (extendedVisitContext = (ExtendedVisitContext)context).getVisitMode() == ExtendedVisitContextMode.RENDER && (result = extendedVisitContext.invokeMetaComponentVisitCallback((UIComponent)this, callback, SUBTREE_META_COMPONENT_ID)) != VisitResult.ACCEPT) {
            return result == VisitResult.COMPLETE;
        }
        return super.visitTree(context, callback);
    }

    public void encodeMetaComponent(FacesContext context, String metaComponentId) throws IOException {
        ((MetaComponentRenderer)this.getRenderer(context)).encodeMetaComponent(context, (UIComponent)this, metaComponentId);
    }

    static enum PropertyKeys {
        expanded;

    }
}

