/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine;

import java.util.Iterator;
import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.engine.CascadingAction;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.event.EventSource;
import org.hibernate.type.CollectionType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class EJB3CascadingAction
extends CascadingAction {
    private static Logger log = LoggerFactory.getLogger(CascadingAction.class);
    public static final CascadingAction PERSIST_SKIPLAZY = new CascadingAction(){

        public void cascade(EventSource session, Object child, String entityName, Object anything, boolean isCascadeDeleteEnabled) throws HibernateException {
            log.trace("cascading to persist: {}", (Object)entityName);
            session.persist(entityName, child, (Map)anything);
        }

        public Iterator getCascadableChildrenIterator(EventSource session, CollectionType collectionType, Object collection) {
            return CascadingAction.getLoadedElementsIterator((SessionImplementor)session, (CollectionType)collectionType, (Object)collection);
        }

        public boolean deleteOrphans() {
            return false;
        }

        public boolean performOnLazyProperty() {
            return false;
        }

        public String toString() {
            return "ACTION_PERSIST_SKIPLAZY";
        }
    };
}

