/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.rendering.wiki;

import freemarker.core.Environment;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.platform.rendering.wiki.Toc;
import org.nuxeo.ecm.platform.rendering.wiki.WikiEntityUtil;
import org.nuxeo.ecm.platform.rendering.wiki.WikiExpression;
import org.nuxeo.ecm.platform.rendering.wiki.WikiMacro;
import org.nuxeo.ecm.platform.rendering.wiki.WikiSerializer;
import org.nuxeo.ecm.platform.rendering.wiki.WikiWriter;
import org.nuxeo.ecm.platform.rendering.wiki.extensions.WikiBlockWriter;
import org.wikimodel.wem.PrintListener;
import org.wikimodel.wem.WikiFormat;
import org.wikimodel.wem.WikiParameters;

public class WikiSerializerHandler
extends PrintListener {
    public static final Log log = LogFactory.getLog(WikiSerializerHandler.class);
    protected static final String LINE_SEP = System.getProperty("line.separator");
    protected final WikiSerializer engine;
    protected final StringBuilder words = new StringBuilder();
    protected Environment env;
    protected WikiWriter writer;
    protected int mark = -1;
    protected Toc toc;

    public WikiSerializerHandler(WikiSerializer engine) {
        super(null);
        this.engine = engine;
        this.writer = new WikiWriter();
        if (engine.macros.containsKey("toc")) {
            this.toc = new Toc();
        }
    }

    protected void print(String str) {
        this.writer.print(str);
    }

    protected void println() {
        this.writer.println();
    }

    protected void println(String str) {
        this.writer.println(str);
    }

    public WikiWriter getWriter() {
        return this.writer;
    }

    public Environment getEnvironment() {
        if (this.env == null) {
            this.env = Environment.getCurrentEnvironment();
        }
        return this.env;
    }

    protected void beginElement() {
        this.flushWords();
    }

    protected void endElement() {
        this.flushWords();
    }

    protected void flushWords() {
        if (this.words.length() == 0) {
            return;
        }
        String text = this.words.toString();
        this.words.setLength(0);
        int len = this.engine.filters.size();
        for (int i = 0; i < len; ++i) {
            String result = this.engine.filters.get(i).apply(text);
            if (result == null) continue;
            this.print(result);
            return;
        }
        this.print(text);
    }

    public void beginDefinitionDescription() {
        this.beginElement();
        super.beginDefinitionDescription();
    }

    public void beginDefinitionList(WikiParameters parameters) {
        this.beginElement();
        super.beginDefinitionList(parameters);
    }

    public void beginDefinitionTerm() {
        this.beginElement();
        super.beginDefinitionTerm();
    }

    public void beginDocument() {
        this.beginElement();
        super.beginDocument();
    }

    public void beginFormat(WikiFormat format) {
        this.beginElement();
        super.beginFormat(format);
    }

    public void beginHeader(int level, WikiParameters params) {
        this.beginElement();
        super.beginHeader(level, params);
        if (this.toc != null) {
            String id = this.toc.addHeading(null, level);
            this.print("<a name=\"heading_" + id + "\">");
            this.mark = this.writer.getBuffer().length();
        }
    }

    public void beginInfoBlock(char infoType, WikiParameters params) {
        this.beginElement();
        super.beginInfoBlock(infoType, params);
    }

    public void beginList(WikiParameters parameters, boolean ordered) {
        this.beginElement();
        super.beginList(parameters, ordered);
    }

    public void beginListItem() {
        this.beginElement();
        super.beginListItem();
    }

    public void beginParagraph(WikiParameters params) {
        this.beginElement();
        super.beginParagraph(params);
    }

    public void beginPropertyBlock(String propertyUri, boolean doc) {
        this.beginElement();
        if (propertyUri.startsWith("block:")) {
            String name = propertyUri.substring(6);
            WikiBlockWriter bwriter = new WikiBlockWriter(this.writer, name);
            this.writer.writeText(bwriter);
            this.writer = bwriter;
        } else {
            super.beginPropertyBlock(propertyUri, doc);
        }
    }

    public void beginPropertyInline(String str) {
        this.beginElement();
        super.beginPropertyInline(str);
    }

    public void beginQuotation(WikiParameters params) {
        this.beginElement();
        super.beginQuotation(params);
    }

    public void beginQuotationLine() {
        this.beginElement();
        super.beginQuotationLine();
    }

    public void beginTable(WikiParameters params) {
        this.beginElement();
        super.beginTable(params);
    }

    public void beginTableCell(boolean tableHead, WikiParameters params) {
        this.beginElement();
        super.beginTableCell(tableHead, params);
    }

    public void beginTableRow(WikiParameters params) {
        this.beginElement();
        super.beginTableRow(params);
    }

    public void endDefinitionDescription() {
        this.endElement();
        super.endDefinitionDescription();
    }

    public void endDefinitionList(WikiParameters parameters) {
        this.endElement();
        super.endDefinitionList(parameters);
    }

    public void endDefinitionTerm() {
        this.endElement();
        super.endDefinitionTerm();
    }

    public void endDocument() {
        this.endElement();
        super.endDocument();
    }

    public void endFormat(WikiFormat format) {
        this.endElement();
        super.endFormat(format);
    }

    public void endHeader(int level, WikiParameters params) {
        if (this.toc != null) {
            if (this.mark == -1) {
                throw new IllegalStateException("marker was not set");
            }
            this.toc.tail.title = this.writer.getBuffer().substring(this.mark);
            this.mark = -1;
            this.print("</a>");
            super.endHeader(level, params);
        } else {
            super.endHeader(level, params);
        }
        this.endElement();
    }

    public void endInfoBlock(char infoType, WikiParameters params) {
        this.endElement();
        super.endInfoBlock(infoType, params);
    }

    public void endList(WikiParameters parameters, boolean ordered) {
        this.endElement();
        super.endList(parameters, ordered);
    }

    public void endListItem() {
        this.endElement();
        super.endListItem();
    }

    public void endParagraph(WikiParameters params) {
        this.endElement();
        super.endParagraph(params);
    }

    public void endPropertyBlock(String propertyUri, boolean doc) {
        this.endElement();
        if (propertyUri.startsWith("block:")) {
            this.writer = this.writer.getParent();
            if (this.writer == null) {
                throw new IllegalStateException("block macro underflow");
            }
        } else {
            super.endPropertyBlock(propertyUri, doc);
        }
    }

    public void endPropertyInline(String inlineProperty) {
        this.endElement();
        super.endPropertyInline(inlineProperty);
    }

    public void endQuotation(WikiParameters params) {
        this.endElement();
        super.endQuotation(params);
    }

    public void endQuotationLine() {
        this.endElement();
        super.endQuotationLine();
    }

    public void endTable(WikiParameters params) {
        this.endElement();
        super.endTable(params);
    }

    public void endTableCell(boolean tableHead, WikiParameters params) {
        this.endElement();
        super.endTableCell(tableHead, params);
    }

    public void endTableRow(WikiParameters params) {
        this.endElement();
        super.endTableRow(params);
    }

    public void onEmptyLines(int count) {
        this.flushWords();
        super.onEmptyLines(count);
    }

    public void onHorizontalLine() {
        this.flushWords();
        super.onHorizontalLine();
    }

    public void onLineBreak() {
        this.flushWords();
        super.onLineBreak();
    }

    public void onReference(String ref, boolean explicitLink) {
        this.flushWords();
        super.onReference(ref, explicitLink);
    }

    public void onTableCaption(String str) {
        this.flushWords();
        super.onTableCaption(str);
    }

    public void onVerbatimBlock(String str) {
        this.flushWords();
        super.onVerbatimBlock(str);
    }

    public void onVerbatimInline(String str) {
        this.flushWords();
        super.onVerbatimInline(str);
    }

    public void onMacroBlock(String macroName, WikiParameters params, String content) {
        this.flushWords();
        WikiMacro expression = this.engine.macros.get(macroName);
        if (expression != null) {
            try {
                expression.eval(params, content, this);
            }
            catch (Exception e) {
                log.error((Object)"Failed to eval macro", (Throwable)e);
            }
        } else {
            log.warn((Object)("Unknown wiki macro: " + macroName));
        }
    }

    public void onMacroInline(String macroName, WikiParameters params, String content) {
        this.flushWords();
        WikiMacro expression = this.engine.macros.get(macroName);
        if (expression != null) {
            try {
                expression.evalInline(params, content, this);
            }
            catch (Exception e) {
                log.error((Object)"Failed to eval macro", (Throwable)e);
            }
        } else {
            log.warn((Object)("Unknown wiki macro: " + macroName));
        }
    }

    public void onExtensionBlock(String extensionName, WikiParameters params) {
        this.flushWords();
        WikiExpression expression = this.engine.expressions.get(extensionName);
        if (expression != null) {
            try {
                expression.eval(params, this);
            }
            catch (Exception e) {
                log.error((Object)"Failed to eval expression", (Throwable)e);
            }
        } else {
            log.warn((Object)("Unknown wiki expression: " + extensionName));
        }
    }

    public void onExtensionInline(String extensionName, WikiParameters params) {
        this.flushWords();
        WikiExpression expression = this.engine.expressions.get(extensionName);
        if (expression != null) {
            try {
                expression.evalInline(params, this);
            }
            catch (Exception e) {
                log.error((Object)"Failed to eval expression", (Throwable)e);
            }
        } else {
            log.warn((Object)("Unknown wiki expression: " + extensionName));
        }
    }

    public void onSpecialSymbol(String str) {
        String entity = this.getSymbolEntity(str);
        if (entity != null) {
            this.words.append(entity);
        } else {
            this.words.append(str);
        }
    }

    public void onSpace(String str) {
        this.flushWords();
        super.onSpace(str);
    }

    public void onNewLine() {
        this.flushWords();
        super.onNewLine();
    }

    public void onEscape(String str) {
        this.flushWords();
        super.onEscape(str);
    }

    public void onWord(String word) {
        this.words.append(word);
    }

    protected void writeWord(String word) {
        int len = this.engine.filters.size();
        for (int i = 0; i < len; ++i) {
            String result = this.engine.filters.get(i).apply(word);
            if (result == null) continue;
            this.print(result);
            return;
        }
        this.print(word);
    }

    protected String getSymbolEntity(String str) {
        String entity = null;
        if (this.isHtmlEntities()) {
            entity = WikiEntityUtil.getHtmlSymbol(str);
        } else {
            int code = WikiEntityUtil.getHtmlCodeByWikiSymbol(str);
            if (code > 0) {
                entity = "#" + Integer.toString(code);
            }
        }
        if (entity != null) {
            entity = "&" + entity + ";";
            if (str.startsWith(" --")) {
                entity = "&nbsp;" + entity + " ";
            }
        }
        return entity;
    }

    protected boolean isHtmlEntities() {
        return true;
    }
}

