/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.dbs;

import java.io.Serializable;
import org.nuxeo.ecm.core.storage.State;
import org.nuxeo.ecm.core.storage.StateHelper;

public class DBSDocumentState {
    protected State state;
    protected State originalState;

    public DBSDocumentState() {
        this.state = new State();
        this.originalState = null;
    }

    public DBSDocumentState(State base) {
        this.state = StateHelper.deepCopy((State)base);
        this.originalState = null;
    }

    public void markDirty() {
        if (this.originalState == null) {
            this.originalState = StateHelper.deepCopy((State)this.state);
        }
    }

    public boolean isDirty() {
        return this.originalState != null;
    }

    public boolean isDirtyIgnoringFulltext() {
        State.StateDiff diff = this.getStateChange();
        if (diff == null) {
            return false;
        }
        diff.remove((Object)"ecm:fulltextSimple");
        diff.remove((Object)"ecm:fulltextBinary");
        diff.remove((Object)"ecm:fulltextJobId");
        return !diff.isEmpty();
    }

    public void setNotDirty() {
        this.originalState = null;
        StateHelper.resetDeltas((State)this.state);
    }

    public State getState() {
        return this.state;
    }

    public State.StateDiff getStateChange() {
        if (this.originalState == null) {
            return null;
        }
        State.StateDiff diff = StateHelper.diff((State)this.originalState, (State)this.state);
        if (diff.isEmpty()) {
            return null;
        }
        return diff;
    }

    public Serializable get(String key) {
        return this.state.get((Object)key);
    }

    public void put(String key, Serializable value) {
        this.markDirty();
        this.state.put(key, value);
    }

    public boolean containsKey(String key) {
        return this.state.get((Object)key) != null;
    }

    public String getId() {
        return (String)((Object)this.get("ecm:id"));
    }

    public String getParentId() {
        return (String)((Object)this.get("ecm:parentId"));
    }

    public String getName() {
        return (String)((Object)this.get("ecm:name"));
    }

    public String getPrimaryType() {
        return (String)((Object)this.get("ecm:primaryType"));
    }

    public String getVersionSeriesId() {
        return (String)((Object)this.get("ecm:versionSeriesId"));
    }

    public String toString() {
        return this.getClass().getSimpleName() + '(' + (this.isDirty() ? "dirty," : "") + this.state.toString() + ')';
    }
}

