/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.pictures.tiles.gimp;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuxeo.ecm.platform.pictures.tiles.service.PictureTilingComponent;

public class GimpExecutor {
    private static String gimpOpts = "--no-interface --batch ";
    private static String gimpQuit = " --batch '(gimp-quit 1)'";
    private static String GIMPLOG_PREFIX = "*NXGIMPLOG*";
    protected static boolean useQuickExec = false;
    private static String gimpPath;

    private static boolean isWindows() {
        String osName = System.getProperty("os.name");
        return osName.toLowerCase().contains("windows");
    }

    public static void setUseQuickExec(boolean quickExec) {
        useQuickExec = quickExec;
    }

    protected static Map<String, String> execCmd(String[] cmd) throws Exception {
        long t0 = System.currentTimeMillis();
        Process p1 = Runtime.getRuntime().exec(cmd);
        int exitValue = p1.waitFor();
        HashMap<String, String> result = new HashMap<String, String>();
        if (exitValue == 0) {
            String strLine;
            BufferedReader stdInput = new BufferedReader(new InputStreamReader(p1.getInputStream()));
            while ((strLine = stdInput.readLine()) != null) {
                if (!strLine.startsWith(GIMPLOG_PREFIX)) continue;
                String resLine = strLine.substring(GIMPLOG_PREFIX.length());
                String[] res = resLine.split(":");
                result.put(res[0].trim(), res[1].trim());
            }
        }
        long t1 = System.currentTimeMillis();
        result.put("JavaProcessExecTime", t1 - t0 + "ms");
        return result;
    }

    protected static Map<String, String> quickExecCmd(String[] cmd) throws Exception {
        long t0 = System.currentTimeMillis();
        Process p1 = Runtime.getRuntime().exec(cmd);
        boolean execTerminated = false;
        HashMap<String, String> result = new HashMap<String, String>();
        while (!execTerminated) {
            String strLine;
            BufferedReader stdInput = new BufferedReader(new InputStreamReader(p1.getInputStream()));
            while ((strLine = stdInput.readLine()) != null) {
                if (!strLine.startsWith(GIMPLOG_PREFIX)) continue;
                String resLine = strLine.substring(GIMPLOG_PREFIX.length());
                String[] res = resLine.split(":");
                result.put(res[0].trim(), res[1].trim());
            }
            if (result.containsKey("ReturnCode")) {
                execTerminated = true;
            }
            try {
                int exitCode = p1.exitValue();
                execTerminated = true;
            }
            catch (IllegalThreadStateException illegalThreadStateException) {}
        }
        long t1 = System.currentTimeMillis();
        result.put("JavaProcessExecTime", t1 - t0 + "ms");
        return result;
    }

    public static Map<String, String> exec(String procName, List<Object> params) throws Exception {
        StringBuffer procStringBuf = new StringBuffer();
        procStringBuf.append("'(");
        procStringBuf.append(procName);
        procStringBuf.append(" RUN-NONINTERACTIVE ");
        for (Object p : params) {
            if (p instanceof String) {
                String pStr = (String)p;
                procStringBuf.append(" \"");
                procStringBuf.append(pStr);
                procStringBuf.append("\"");
                continue;
            }
            if (!(p instanceof Integer)) continue;
            Integer pInt = (Integer)p;
            procStringBuf.append(" ");
            procStringBuf.append(pInt.toString());
        }
        procStringBuf.append(")'");
        String procString = procStringBuf.toString();
        String[] cmd = new String[]{"/bin/sh", "-c", GimpExecutor.getGimpPath() + " " + gimpOpts + procString + gimpQuit + " 2>&1"};
        if (GimpExecutor.isWindows()) {
            cmd[0] = "cmd";
            cmd[1] = "/C";
        }
        if (useQuickExec) {
            return GimpExecutor.quickExecCmd(cmd);
        }
        return GimpExecutor.execCmd(cmd);
    }

    protected static String getGimpPath() {
        if (gimpPath == null || "".equals(gimpPath)) {
            gimpPath = GimpExecutor.isWindows() ? PictureTilingComponent.getEnvValue("GimpExecutable", "gimp.exe") : PictureTilingComponent.getEnvValue("GimpExecutable", "gimp");
        }
        return gimpPath;
    }
}

