/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.platform.portal.notifications.veto;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.platform.ec.notification.NotificationListenerVeto;

public class NotificationsVeto
implements NotificationListenerVeto {
    public static final List<String> authorizedSystemEvents = new ArrayList<String>(5){
        {
            this.add("workflowProcessCanceled");
            this.add("workflowAbandoned");
            this.add("workflowTaskAssigned");
            this.add("workflowTaskCompleted");
            this.add("workflowTaskRejected");
        }
    };

    public boolean accept(Event event) throws Exception {
        String eventName = event.getName();
        DocumentEventContext docCtx = (DocumentEventContext)event.getContext();
        NuxeoPrincipal currentUser = (NuxeoPrincipal)docCtx.getPrincipal();
        boolean isSystemInitiator = StringUtils.equalsIgnoreCase((String)"system", (String)currentUser.getName());
        if (isSystemInitiator) {
            return authorizedSystemEvents.contains(eventName);
        }
        return !isSystemInitiator;
    }
}

