/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.jtajca;

import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XObject;

@XObject(value="pool")
public class NuxeoConnectionManagerConfiguration {
    public static final int DEFAULT_MAX_POOL_SIZE = 20;
    public static final int DEFAULT_MIN_POOL_SIZE = 0;
    public static final int DEFAULT_BLOCKING_TIMEOUT_MILLIS = 100;
    public static final int DEFAULT_IDLE_TIMEOUT_MINUTES = 0;
    @XNode(value="@name")
    private String name = "NuxeoConnectionManager";
    @XNode(value="@xaMode")
    private Boolean xaMode;
    @XNode(value="@useTransactionCaching")
    private Boolean useTransactionCaching;
    @XNode(value="@useThreadCaching")
    private Boolean useThreadCaching;
    @XNode(value="@matchOne")
    private Boolean matchOne;
    @XNode(value="@matchAll")
    private Boolean matchAll;
    @XNode(value="@selectOneNoMatch")
    private Boolean selectOneNoMatch;
    @XNode(value="@maxPoolSize")
    private Integer maxPoolSize;
    @XNode(value="@minPoolSize")
    private Integer minPoolSize;
    @XNode(value="@blockingTimeoutMillis")
    private Integer blockingTimeoutMillis;
    @XNode(value="@idleTimeoutMinutes")
    private Integer idleTimeoutMinutes;

    public NuxeoConnectionManagerConfiguration() {
    }

    public NuxeoConnectionManagerConfiguration(NuxeoConnectionManagerConfiguration other) {
        this.name = other.name;
        this.useTransactionCaching = other.useTransactionCaching;
        this.useThreadCaching = other.useThreadCaching;
        this.matchOne = other.matchOne;
        this.matchAll = other.matchAll;
        this.selectOneNoMatch = other.selectOneNoMatch;
        this.maxPoolSize = other.maxPoolSize;
        this.minPoolSize = other.minPoolSize;
        this.blockingTimeoutMillis = other.blockingTimeoutMillis;
        this.idleTimeoutMinutes = other.idleTimeoutMinutes;
    }

    public void merge(NuxeoConnectionManagerConfiguration other) {
        if (other.name != null) {
            this.name = other.name;
        }
        if (other.xaMode.booleanValue()) {
            this.xaMode = other.xaMode;
        }
        if (other.useTransactionCaching != null) {
            this.useTransactionCaching = other.useTransactionCaching;
        }
        if (other.useThreadCaching != null) {
            this.useThreadCaching = other.useThreadCaching;
        }
        if (other.matchOne != null) {
            this.matchOne = other.matchOne;
        }
        if (other.matchAll != null) {
            this.matchAll = other.matchAll;
        }
        if (other.selectOneNoMatch != null) {
            this.selectOneNoMatch = other.selectOneNoMatch;
        }
        if (other.maxPoolSize != null) {
            this.maxPoolSize = other.maxPoolSize;
        }
        if (other.minPoolSize != null) {
            this.minPoolSize = other.minPoolSize;
        }
        if (other.blockingTimeoutMillis != null) {
            this.blockingTimeoutMillis = other.blockingTimeoutMillis;
        }
        if (other.idleTimeoutMinutes != null) {
            this.idleTimeoutMinutes = other.idleTimeoutMinutes;
        }
    }

    private static boolean defaultFalse(Boolean bool) {
        return Boolean.TRUE.equals(bool);
    }

    private static boolean defaultTrue(Boolean bool) {
        return !Boolean.FALSE.equals(bool);
    }

    private static int defaultInt(Integer value, int def) {
        return value == null ? def : value;
    }

    public String getName() {
        return this.name;
    }

    public boolean getXAMode() {
        return NuxeoConnectionManagerConfiguration.defaultTrue(this.xaMode);
    }

    public boolean getUseTransactionCaching() {
        return NuxeoConnectionManagerConfiguration.defaultTrue(this.useTransactionCaching);
    }

    public boolean getUseThreadCaching() {
        return NuxeoConnectionManagerConfiguration.defaultTrue(this.useThreadCaching);
    }

    public boolean getMatchOne() {
        return NuxeoConnectionManagerConfiguration.defaultTrue(this.matchOne);
    }

    public boolean getMatchAll() {
        return NuxeoConnectionManagerConfiguration.defaultTrue(this.matchAll);
    }

    public boolean getSelectOneNoMatch() {
        return NuxeoConnectionManagerConfiguration.defaultFalse(this.selectOneNoMatch);
    }

    public int getMaxPoolSize() {
        return NuxeoConnectionManagerConfiguration.defaultInt(this.maxPoolSize, 20);
    }

    public int getMinPoolSize() {
        return NuxeoConnectionManagerConfiguration.defaultInt(this.minPoolSize, 0);
    }

    public int getBlockingTimeoutMillis() {
        return NuxeoConnectionManagerConfiguration.defaultInt(this.blockingTimeoutMillis, 100);
    }

    public int getIdleTimeoutMinutes() {
        return NuxeoConnectionManagerConfiguration.defaultInt(this.idleTimeoutMinutes, 0);
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setXAMode(boolean xaMode) {
        this.xaMode = xaMode;
    }

    public void setUseTransactionCaching(boolean useTransactionCaching) {
        this.useTransactionCaching = useTransactionCaching;
    }

    public void setUseThreadCaching(boolean useThreadCaching) {
        this.useThreadCaching = useThreadCaching;
    }

    public void setMatchOne(boolean matchOne) {
        this.matchOne = matchOne;
    }

    public void setMatchAll(boolean matchAll) {
        this.matchAll = matchAll;
    }

    public void setSelectOneNoMatch(boolean selectOneNoMatch) {
        this.selectOneNoMatch = selectOneNoMatch;
    }

    public void setMaxPoolSize(int maxPoolSize) {
        this.maxPoolSize = maxPoolSize;
    }

    public void setMinPoolSize(int minPoolSize) {
        this.minPoolSize = minPoolSize;
    }

    public void setBlockingTimeoutMillis(int blockingTimeoutMillis) {
        this.blockingTimeoutMillis = blockingTimeoutMillis;
    }

    public void setIdleTimeoutMinutes(int idleTimeoutMinutes) {
        this.idleTimeoutMinutes = idleTimeoutMinutes;
    }

    @XNode(value="@maxActive")
    public void setMaxActive(int num) {
        this.maxPoolSize = num;
        LogFactory.getLog(NuxeoConnectionManagerConfiguration.class).warn((Object)"maxActive deprecated dbcp pool attribute usage, should use maxPoolSize geronimo pool attribute instead");
    }

    @XNode(value="@maxIdle")
    public void setMaxIdle(int num) {
        this.minPoolSize = num;
        LogFactory.getLog(NuxeoConnectionManagerConfiguration.class).warn((Object)"maxIdle deprecated dbcp pool attribute usage, should use minPoolSize geronimo pool attribute instead");
    }

    @XNode(value="@maxWait")
    public void setMaxWait(int num) {
        this.blockingTimeoutMillis = num;
        LogFactory.getLog(NuxeoConnectionManagerConfiguration.class).warn((Object)"maxWait deprecated dbcp pool attribute usage, should use blockingTimeoutMillis geronimo pool attribute instead");
    }
}

