/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import org.nuxeo.ecm.core.api.impl.FacetFilter;
import org.nuxeo.ecm.core.query.sql.model.Expression;
import org.nuxeo.ecm.core.query.sql.model.FromClause;
import org.nuxeo.ecm.core.query.sql.model.FromList;
import org.nuxeo.ecm.core.query.sql.model.Literal;
import org.nuxeo.ecm.core.query.sql.model.LiteralList;
import org.nuxeo.ecm.core.query.sql.model.MultiExpression;
import org.nuxeo.ecm.core.query.sql.model.Operand;
import org.nuxeo.ecm.core.query.sql.model.Operator;
import org.nuxeo.ecm.core.query.sql.model.Reference;
import org.nuxeo.ecm.core.query.sql.model.SQLQuery;
import org.nuxeo.ecm.core.query.sql.model.SelectClause;
import org.nuxeo.ecm.core.query.sql.model.SelectList;
import org.nuxeo.ecm.core.query.sql.model.StringLiteral;
import org.nuxeo.ecm.core.schema.DocumentType;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.runtime.api.Framework;

public class QueryOptimizer {
    public static final String TYPE_ROOT = "Root";
    public static final String TYPE_DOCUMENT = "Document";
    public static final String TYPE_RELATION = "Relation";
    protected final SchemaManager schemaManager = (SchemaManager)Framework.getLocalService(SchemaManager.class);
    protected final Set<String> neverPerInstanceMixins = new HashSet<String>(this.schemaManager.getNoPerDocumentQueryFacets());
    protected final LinkedList<Operand> toplevelOperands = new LinkedList();
    protected boolean onlyRelations;

    public boolean hasSelectFulltextScore(SQLQuery query) {
        SelectClause node = query.select;
        SelectList elements = node.elements;
        for (int i = 0; i < elements.size(); ++i) {
            if (!"ecm:fulltextScore".equals(elements.getKey(i))) continue;
            return true;
        }
        return false;
    }

    public MultiExpression getOptimizedQuery(SQLQuery query, FacetFilter facetFilter) {
        if (facetFilter != null) {
            this.addFacetFilterClauses(facetFilter);
        }
        this.visitFromClause(query.from);
        if (query.where != null) {
            this.analyzeToplevelOperands((Operand)query.where.predicate);
        }
        this.simplifyToplevelOperands();
        return new MultiExpression(Operator.AND, this.toplevelOperands);
    }

    protected void addFacetFilterClauses(FacetFilter facetFilter) {
        for (Object mixin : facetFilter.required) {
            Expression expr = new Expression((Operand)new Reference("ecm:mixinType"), Operator.EQ, (Operand)new StringLiteral((String)mixin));
            this.toplevelOperands.add((Operand)expr);
        }
        if (!facetFilter.excluded.isEmpty()) {
            LiteralList list = new LiteralList();
            for (String mixin : facetFilter.excluded) {
                list.add((Object)new StringLiteral(mixin));
            }
            Expression expr = new Expression((Operand)new Reference("ecm:mixinType"), Operator.NOTIN, (Operand)list);
            this.toplevelOperands.add((Operand)expr);
        }
    }

    protected void visitFromClause(FromClause node) {
        this.onlyRelations = true;
        HashSet fromTypes = new HashSet();
        FromList elements = node.elements;
        for (int i = 0; i < elements.size(); ++i) {
            DocumentType t;
            Set subTypes;
            String typeName = (String)elements.get(i);
            if (TYPE_DOCUMENT.equalsIgnoreCase(typeName)) {
                typeName = TYPE_DOCUMENT;
            }
            if ((subTypes = this.schemaManager.getDocumentTypeNamesExtending(typeName)) == null) {
                throw new RuntimeException("Unknown type: " + typeName);
            }
            fromTypes.addAll(subTypes);
            boolean isRelation = false;
            do {
                if (TYPE_RELATION.equals(typeName)) {
                    isRelation = true;
                    break;
                }
                t = this.schemaManager.getDocumentType(typeName);
                if (t == null) continue;
                t = t.getSuperType();
            } while ((typeName = t == null ? null : t.getName()) != null);
            this.onlyRelations = this.onlyRelations && isRelation;
        }
        fromTypes.remove(TYPE_ROOT);
        LiteralList list = new LiteralList();
        for (String type : fromTypes) {
            list.add((Object)new StringLiteral(type));
        }
        this.toplevelOperands.add((Operand)new Expression((Operand)new Reference("ecm:primaryType"), Operator.IN, (Operand)list));
    }

    protected void analyzeToplevelOperands(Operand node) {
        if (node instanceof Expression) {
            Expression expr = (Expression)node;
            Operator op = expr.operator;
            if (op == Operator.AND) {
                this.analyzeToplevelOperands(expr.lvalue);
                this.analyzeToplevelOperands(expr.rvalue);
                return;
            }
        }
        this.toplevelOperands.add(node);
    }

    protected void simplifyToplevelOperands() {
        Set<String> primaryTypes = null;
        Iterator it = this.toplevelOperands.iterator();
        while (it.hasNext()) {
            String mixin;
            Operand node = (Operand)it.next();
            if (!(node instanceof Expression)) continue;
            Expression expr = (Expression)node;
            if (!(expr.lvalue instanceof Reference)) continue;
            String name = ((Reference)expr.lvalue).name;
            Operator op = expr.operator;
            Operand rvalue = expr.rvalue;
            if ("ecm:primaryType".equals(name)) {
                Set<String> set;
                if (op != Operator.EQ && op != Operator.IN) continue;
                if (op == Operator.EQ) {
                    if (!(rvalue instanceof StringLiteral)) continue;
                    String primaryType = ((StringLiteral)rvalue).value;
                    set = new HashSet<String>(Collections.singleton(primaryType));
                } else {
                    if (!(rvalue instanceof LiteralList)) continue;
                    set = QueryOptimizer.getStringLiterals((LiteralList)rvalue);
                }
                if (primaryTypes == null) {
                    primaryTypes = set;
                } else {
                    primaryTypes.retainAll(set);
                }
                it.remove();
                continue;
            }
            if (!"ecm:mixinType".equals(name) || op != Operator.EQ && op != Operator.NOTEQ || !(rvalue instanceof StringLiteral) || !this.neverPerInstanceMixins.contains(mixin = ((StringLiteral)rvalue).value)) continue;
            Set set = this.schemaManager.getDocumentTypeNamesForFacet(mixin);
            if (set == null) {
                set = Collections.emptySet();
            }
            if (primaryTypes == null) {
                if (op != Operator.EQ) continue;
                primaryTypes = new HashSet(set);
            } else if (op == Operator.EQ) {
                primaryTypes.retainAll(set);
            } else {
                primaryTypes.removeAll(set);
            }
            it.remove();
        }
        if (primaryTypes != null) {
            Expression expr;
            if (primaryTypes.isEmpty()) {
                primaryTypes.add("__NOSUCHTYPE__");
            }
            if (primaryTypes.size() == 1) {
                String pt = (String)primaryTypes.iterator().next();
                expr = new Expression((Operand)new Reference("ecm:primaryType"), Operator.EQ, (Operand)new StringLiteral(pt));
            } else {
                LiteralList list = new LiteralList();
                for (String pt : primaryTypes) {
                    list.add((Object)new StringLiteral(pt));
                }
                expr = new Expression((Operand)new Reference("ecm:primaryType"), Operator.IN, (Operand)list);
            }
            this.toplevelOperands.addFirst((Operand)expr);
        }
    }

    protected static Set<String> getStringLiterals(LiteralList list) {
        HashSet<String> set = new HashSet<String>();
        for (Literal literal : list) {
            if (!(literal instanceof StringLiteral)) {
                throw new RuntimeException("requires string literals");
            }
            set.add(((StringLiteral)literal).value);
        }
        return set;
    }
}

