/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.automation;

import fr.toutatice.ecm.platform.core.helper.ToutaticeDocumentHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentSecurityException;
import org.nuxeo.ecm.core.api.Filter;
import org.nuxeo.ecm.core.model.NoSuchDocumentException;

@Operation(id="Document.FetchWorkspaceOfDocument", category="Fetch", label="Fetch workspace of document", description="Fetch the workspace of a given document.")
public class FetchWorkspaceOfDocument {
    public static final String ID = "Document.FetchWorkspaceOfDocument";
    private static final Log log = LogFactory.getLog(FetchWorkspaceOfDocument.class);
    @Context
    protected CoreSession coreSession;
    @Param(name="document", required=true)
    protected DocumentModel document;

    @OperationMethod
    public Object run() throws Exception {
        DocumentModel workspace = null;
        WorksapceDocumentFilter filter = new WorksapceDocumentFilter();
        if (filter.accept(this.document)) {
            workspace = this.document;
        } else {
            DocumentModelList parentList = ToutaticeDocumentHelper.getParentList((CoreSession)this.coreSession, (DocumentModel)this.document, (Filter)filter, (boolean)true);
            if (parentList != null && parentList.size() > 0) {
                workspace = (DocumentModel)parentList.get(0);
                if (!this.coreSession.hasPermission(workspace.getRef(), "Read")) {
                    throw new DocumentSecurityException(this.document.getPathAsString());
                }
            } else {
                throw new NoSuchDocumentException(this.document.getPathAsString());
            }
        }
        return workspace;
    }

    protected class WorksapceDocumentFilter
    implements Filter {
        private static final long serialVersionUID = 5364940781195839390L;
        public String WORKSPACE_TYPE = "Workspace";
        public String USER_WORKSPACE_TYPE = "UserWorkspace";

        protected WorksapceDocumentFilter() {
        }

        public boolean accept(DocumentModel document) {
            return this.WORKSPACE_TYPE.equals(document.getType()) || this.USER_WORKSPACE_TYPE.equals(document.getType());
        }
    }
}

