/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.automation;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.collectors.DocumentModelCollector;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.directory.Directory;
import org.nuxeo.ecm.directory.api.DirectoryService;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.runtime.api.Framework;

@Operation(id="Document.RefreshPrincipal", category="Users & Groups", label="Refresh princial", description="Refresh the principal (to take into consideration LDAP updates)")
public class RefreshPrincipal {
    private static final Log log = LogFactory.getLog(RefreshPrincipal.class);
    public static final String ID = "Document.RefreshPrincipal";
    @Context
    protected OperationContext ctx;

    @OperationMethod
    public void run() throws Exception {
        try {
            NuxeoPrincipal principal = (NuxeoPrincipal)this.ctx.getPrincipal();
            UserManager userManager = (UserManager)Framework.getService(UserManager.class);
            DirectoryService directoryService = (DirectoryService)Framework.getLocalService(DirectoryService.class);
            String userDirectoryName = userManager.getUserDirectoryName();
            Directory userDirectory = directoryService.getDirectory(userDirectoryName);
            userDirectory.getCache().invalidate(new String[]{principal.getName()});
            DocumentModel um = userManager.getUserModel(principal.getName());
            principal.setModel(um);
        }
        catch (Exception e) {
            log.warn((Object)("Failed to refresh the principal, error: " + e.getMessage()));
            throw new ClientException((Throwable)e);
        }
    }

    @OperationMethod(collector=DocumentModelCollector.class)
    public DocumentModel run(DocumentModel doc) throws Exception {
        this.run();
        return this.ctx.getCoreSession().getDocument(doc.getRef());
    }

    @OperationMethod(collector=DocumentModelCollector.class)
    public DocumentModel run(DocumentRef docRef) throws Exception {
        this.run();
        return this.ctx.getCoreSession().getDocument(docRef);
    }
}

