/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.automation.helper;

import com.ibm.icu.util.Calendar;
import java.util.HashMap;
import java.util.Map;

public class TimeDebugger {
    private static Map<String, TimeDebugger> instances = new HashMap<String, TimeDebugger>(0);
    private long startTime;

    private TimeDebugger() {
    }

    public static TimeDebugger getInstance(String methodName, String sessionId) {
        String id = sessionId + methodName;
        TimeDebugger debugger = instances.get(id);
        if (debugger == null) {
            debugger = new TimeDebugger();
            instances.put(id, debugger);
        }
        return debugger;
    }

    public void setStartTime() {
        this.startTime = Calendar.getInstance().getTimeInMillis();
    }

    public long getTotalTime() {
        return Calendar.getInstance().getTimeInMillis() - this.startTime;
    }

    public String getMessage(String methodName, String sessionId, String documentPath, long totalTime) {
        String msg = "*** Method %s TIME = %s ms (sessionId: %s, document: %s)";
        return String.format(msg, methodName, String.valueOf(totalTime), sessionId, documentPath);
    }
}

