/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.api.forms;

import fr.toutatice.portail.cms.nuxeo.api.forms.FormFilter;
import fr.toutatice.portail.cms.nuxeo.api.forms.FormFilterContext;
import fr.toutatice.portail.cms.nuxeo.api.forms.FormFilterException;
import fr.toutatice.portail.cms.nuxeo.api.forms.FormFilterInstance;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.osivia.portal.api.PortalException;
import org.osivia.portal.api.internationalization.Bundle;

public class FormFilterExecutor {
    private Map<String, List<FormFilterInstance>> filtersByParentPathMap;
    private String currentPath;
    private String currentFilterInstanceId;
    private Bundle bundle;

    public FormFilterExecutor(Map<String, List<FormFilterInstance>> filtersByParentPathMap, String currentPath, String currentFilterInstanceId, Bundle bundle) {
        this.filtersByParentPathMap = filtersByParentPathMap;
        this.currentPath = currentPath;
        this.currentFilterInstanceId = currentFilterInstanceId;
        this.bundle = bundle;
    }

    public void executeChildren(FormFilterContext filterContext) throws FormFilterException, PortalException {
        List<FormFilterInstance> filters = this.filtersByParentPathMap.get(this.currentPath);
        if (filters != null) {
            Collections.sort(filters);
            for (FormFilterInstance formFilterI : filters) {
                FormFilter formFilter = formFilterI.getFormFilter();
                if (formFilter != null) {
                    try {
                        formFilter.execute(filterContext, new FormFilterExecutor(this.filtersByParentPathMap, formFilterI.getPath(), formFilterI.getId(), this.bundle));
                        continue;
                    }
                    catch (FormFilterException | PortalException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        throw new PortalException(formFilterI.getName(), (Throwable)e);
                    }
                }
                String msg = this.bundle.getString("FORMS_FILTER_NOT_FOUND", new Object[]{formFilterI.getName()});
                throw new PortalException(msg);
            }
        }
    }

    public String getCurrentFilterInstanceId() {
        return this.currentFilterInstanceId;
    }
}

