/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.theme.tag;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.SimpleTagSupport;
import org.jboss.logging.Logger;
import org.jboss.portal.theme.Orientation;
import org.jboss.portal.theme.impl.JSPRendererContext;
import org.jboss.portal.theme.render.RenderException;
import org.jboss.portal.theme.render.renderer.PageRendererContext;
import org.jboss.portal.theme.render.renderer.RegionRendererContext;

public class RegionTagHandler
extends SimpleTagSupport {
    private static Logger log = Logger.getLogger(RegionTagHandler.class);
    private Orientation regionOrientation;
    private String regionName = null;
    private String regionCssId = null;

    public void doTag() throws JspException, IOException {
        Orientation orientation;
        if (this.regionCssId == null) {
            this.regionCssId = this.regionName;
        }
        log.debug((Object)("rendering " + this.regionName + " [" + this.regionOrientation + "]  cssId[" + this.regionCssId + "]"));
        PageContext app = (PageContext)this.getJspContext();
        HttpServletRequest request = (HttpServletRequest)app.getRequest();
        PageRendererContext page = (PageRendererContext)request.getAttribute("PAGE");
        JspWriter out = this.getJspContext().getOut();
        if (page == null) {
            out.write("<p bgcolor='red'>No page to render!</p>");
            out.write("<p bgcolor='red'>The page to render (PageResult) must be set in the request attribute 'PAGE'</p>");
            out.flush();
            return;
        }
        final String cssId = this.regionCssId == null ? this.regionName : this.regionCssId;
        Orientation orientation2 = orientation = this.regionOrientation == null ? Orientation.DEFAULT : this.regionOrientation;
        if (page.getRegion(this.regionName) == null) {
            RegionRendererContext rrc = new RegionRendererContext(){

                public String getId() {
                    return RegionTagHandler.this.regionName;
                }

                public Collection getWindows() {
                    return Collections.EMPTY_LIST;
                }

                public PageRendererContext getPage() {
                    return null;
                }

                public Orientation getOrientation() {
                    return orientation;
                }

                public String getCSSId() {
                    return cssId;
                }

                public String getProperty(String name) {
                    return null;
                }

                public Map getProperties() {
                    return Collections.EMPTY_MAP;
                }
            };
            JSPRendererContext renderContext = (JSPRendererContext)request.getAttribute("RENDERCONTEXT");
            try {
                PrintWriter pw = new PrintWriter((Writer)out);
                renderContext.setWriter(pw);
                renderContext.render(rrc);
                pw.flush();
            }
            catch (RenderException e) {
                throw new JspException((Throwable)e);
            }
        }
        JSPRendererContext renderContext = (JSPRendererContext)request.getAttribute("RENDERCONTEXT");
        if (renderContext == null) {
            log.debug((Object)"no render context available in request");
            return;
        }
        final RegionRendererContext region = page.getRegion(this.regionName);
        RegionRendererContext rrc = new RegionRendererContext(){

            public String getId() {
                return region.getId();
            }

            public Collection getWindows() {
                return region.getWindows();
            }

            public Orientation getOrientation() {
                return orientation;
            }

            public String getCSSId() {
                return cssId;
            }

            public String getProperty(String name) {
                return region.getProperty(name);
            }

            public Map getProperties() {
                return region.getProperties();
            }
        };
        try {
            PrintWriter pw = new PrintWriter((Writer)out);
            renderContext.setWriter(pw);
            renderContext.render(rrc);
            pw.flush();
        }
        catch (RenderException e) {
            throw new JspException((Throwable)e);
        }
        log.debug((Object)("done rendering page region [" + this.regionName + "]"));
    }

    public void setOrientation(String orientation) {
        if (orientation == null) {
            log.error((Object)"no null value allowed");
        }
        try {
            this.regionOrientation = Orientation.parse(orientation);
        }
        catch (IllegalArgumentException e) {
            log.error((Object)e);
            this.regionOrientation = Orientation.DEFAULT;
        }
    }

    public void setRegionName(String regionName) {
        this.regionName = regionName;
    }

    public void setRegionID(String regionID) {
        this.regionCssId = regionID;
    }
}

