/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.common.adapter;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Map;
import org.jboss.portal.common.adapter.AdaptedMethodDispatcherFactory;
import org.jboss.portal.common.adapter.ClassAdaptable;
import org.jboss.portal.common.adapter.ClassAdapted;
import org.jboss.portal.common.adapter.DefaultJavaLangObjectAdapted;
import org.jboss.portal.common.adapter.JavaLangObjectAdapted;
import org.jboss.portal.common.adapter.JavaLangObjectMethodDispatcherFactory;
import org.jboss.portal.common.adapter.MethodDispatcher;
import org.jboss.portal.common.adapter.MethodDispatcherFactory;

public class ClassAdapter {
    private final Map dispatchers;
    private final Constructor ctor;
    private final InvocationHandler handler = new InvocationHandler(){

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            MethodDispatcher dispatcher = (MethodDispatcher)ClassAdapter.this.dispatchers.get(method);
            ClassAdaptable adaptable = (ClassAdaptable)proxy;
            return dispatcher.dispatch(adaptable, args);
        }
    };

    public ClassAdapter(ClassLoader loader, ClassAdapted[] adapteds) throws NoSuchMethodException, IllegalArgumentException {
        this(loader, adapteds, new DefaultJavaLangObjectAdapted());
    }

    public ClassAdapter(ClassLoader loader, ClassAdapted[] adapteds, JavaLangObjectAdapted objectAdapted) throws NoSuchMethodException, IllegalArgumentException {
        if (loader == null) {
            throw new IllegalArgumentException("No null class loader accepted");
        }
        if (adapteds == null) {
            throw new IllegalArgumentException("No null adapteds accepted");
        }
        if (objectAdapted == null) {
            throw new IllegalArgumentException("No null object adapted accepted");
        }
        this.dispatchers = new HashMap();
        this.addAdapted(Object.class, new JavaLangObjectMethodDispatcherFactory(objectAdapted));
        Class[] itfs = new Class[adapteds.length + 1];
        itfs[0] = ClassAdaptable.class;
        for (int i = 0; i < adapteds.length; ++i) {
            ClassAdapted adapted = adapteds[i];
            if (adapted == null) {
                throw new IllegalArgumentException("No null adapted accepted");
            }
            itfs[1 + i] = adapted.itf;
            this.addAdapted(adapted.itf, new AdaptedMethodDispatcherFactory(adapted.object));
        }
        this.ctor = Proxy.getProxyClass(loader, itfs).getConstructor(InvocationHandler.class);
    }

    private void addAdapted(Class adaptedClass, MethodDispatcherFactory methodDispatcherFactory) {
        Method[] methods = adaptedClass.getMethods();
        for (int j = 0; j < methods.length; ++j) {
            Method method = methods[j];
            int modifiers = method.getModifiers();
            if (!Modifier.isPublic(modifiers) || Modifier.isFinal(modifiers) || Modifier.isStatic(modifiers) || this.dispatchers.containsKey(method)) continue;
            this.dispatchers.put(method, methodDispatcherFactory.createDispatcher(method));
        }
    }

    public ClassAdaptable getAdaptable() throws IllegalAccessException, InstantiationException, InvocationTargetException {
        return (ClassAdaptable)this.ctor.newInstance(this.handler);
    }
}

