/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.graph;

import java.awt.Font;
import java.awt.Paint;
import java.io.File;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.jrobin.core.RrdException;
import org.jrobin.core.Util;
import org.jrobin.data.Plottable;
import org.jrobin.graph.Area;
import org.jrobin.graph.CDef;
import org.jrobin.graph.CommentText;
import org.jrobin.graph.Def;
import org.jrobin.graph.HRule;
import org.jrobin.graph.LegendText;
import org.jrobin.graph.Line;
import org.jrobin.graph.PDef;
import org.jrobin.graph.PlotElement;
import org.jrobin.graph.PrintText;
import org.jrobin.graph.RrdGraphConstants;
import org.jrobin.graph.SDef;
import org.jrobin.graph.Source;
import org.jrobin.graph.SourcedPlotElement;
import org.jrobin.graph.Stack;
import org.jrobin.graph.TimeAxisSetting;
import org.jrobin.graph.VRule;
import org.jrobin.graph.ValueAxisSetting;

public class RrdGraphDef
implements RrdGraphConstants {
    boolean poolUsed = false;
    boolean antiAliasing = false;
    String filename = "-";
    long startTime;
    long endTime;
    TimeAxisSetting timeAxisSetting = null;
    ValueAxisSetting valueAxisSetting = null;
    boolean altYGrid = false;
    boolean noMinorGrid = false;
    boolean altYMrtg = false;
    boolean altAutoscale = false;
    boolean altAutoscaleMax = false;
    int unitsExponent = Integer.MAX_VALUE;
    int unitsLength = 9;
    String verticalLabel = null;
    int width = 400;
    int height = 100;
    boolean interlaced = false;
    String imageInfo = null;
    String imageFormat = "gif";
    float imageQuality = 0.8f;
    String backgroundImage = null;
    String overlayImage = null;
    String unit = null;
    String signature = "Created with JRobin";
    boolean lazy = false;
    double minValue = Double.NaN;
    double maxValue = Double.NaN;
    boolean rigid = false;
    double base = 1000.0;
    boolean logarithmic = false;
    Paint[] colors = new Paint[]{DEFAULT_CANVAS_COLOR, DEFAULT_BACK_COLOR, DEFAULT_SHADEA_COLOR, DEFAULT_SHADEB_COLOR, DEFAULT_GRID_COLOR, DEFAULT_MGRID_COLOR, DEFAULT_FONT_COLOR, DEFAULT_FRAME_COLOR, DEFAULT_ARROW_COLOR};
    boolean noLegend = false;
    boolean onlyGraph = false;
    boolean forceRulesLegend = false;
    String title = null;
    long step = 0L;
    protected Font smallFont;
    protected Font largeFont;
    boolean drawXGrid = true;
    boolean drawYGrid = true;
    int firstDayOfWeek = FIRST_DAY_OF_WEEK;
    boolean showSignature = true;
    File fontDir = null;
    List<Source> sources = new ArrayList<Source>();
    List<CommentText> comments = new ArrayList<CommentText>();
    List<PlotElement> plotElements = new ArrayList<PlotElement>();

    public RrdGraphDef() {
        try {
            this.setTimeSpan(Util.getTimestamps("end-1d", "now"));
        }
        catch (RrdException rrdException) {
            throw new RuntimeException(rrdException);
        }
        String string = System.getProperty("jrobin.fontdir");
        if (string != null && string.length() != 0) {
            this.fontDir = new File(string);
        }
        this.smallFont = new Font(DEFAULT_FONT_NAME, 0, 10);
        this.largeFont = new Font(DEFAULT_FONT_NAME, 1, 12);
    }

    protected Font getFontFromResourceName(String string) {
        Font font = null;
        Exception exception = null;
        URL uRL = null;
        if (this.fontDir != null) {
            try {
                uRL = new URL("file://" + new File(this.fontDir, string).getAbsolutePath());
            }
            catch (MalformedURLException malformedURLException) {
                exception = malformedURLException;
            }
        }
        if (uRL == null) {
            uRL = this.getClass().getResource(string);
        }
        if (uRL != null) {
            try {
                InputStream inputStream = uRL.openStream();
                font = Font.createFont(0, inputStream);
                inputStream.close();
            }
            catch (Exception exception2) {
                exception = exception2;
            }
        } else {
            System.err.println("An error occurred loading the font '" + string + "'.  Falling back to the default.");
            if (exception != null) {
                System.err.println(exception.getLocalizedMessage());
            }
            font = new Font(DEFAULT_FONT_NAME, 0, 10);
        }
        if (font == null) {
            font = new Font(null, 0, 10);
        }
        return font;
    }

    public void setSignature(String string) {
        this.signature = string;
    }

    public String getSignature() {
        return this.signature;
    }

    public void setStartTime(long l) {
        this.startTime = l;
        if (l <= 0L) {
            this.startTime += Util.getTime();
        }
    }

    public void setEndTime(long l) {
        this.endTime = l;
        if (l <= 0L) {
            this.endTime += Util.getTime();
        }
    }

    public void setTimeSpan(long l, long l2) {
        this.setStartTime(l);
        this.setEndTime(l2);
    }

    public void setTimeSpan(long[] lArray) {
        this.setTimeSpan(lArray[0], lArray[lArray.length - 1]);
    }

    public void setPoolUsed(boolean bl) {
        this.poolUsed = bl;
    }

    public void setFilename(String string) {
        this.filename = string;
    }

    public void setTimeAxis(int n, int n2, int n3, int n4, int n5, int n6, int n7, String string) {
        this.timeAxisSetting = new TimeAxisSetting(n, n2, n3, n4, n5, n6, n7, string);
    }

    public void setValueAxis(double d, int n) {
        this.valueAxisSetting = new ValueAxisSetting(d, n);
    }

    public void setAltYGrid(boolean bl) {
        this.altYGrid = bl;
    }

    public void setNoMinorGrid(boolean bl) {
        this.noMinorGrid = bl;
    }

    public void setAltYMrtg(boolean bl) {
        this.altYMrtg = bl;
    }

    public void setAltAutoscale(boolean bl) {
        this.altAutoscale = bl;
    }

    public void setAltAutoscaleMax(boolean bl) {
        this.altAutoscaleMax = bl;
    }

    public void setUnitsExponent(int n) {
        this.unitsExponent = n;
    }

    public void setUnitsLength(int n) {
        this.unitsLength = n;
    }

    public void setVerticalLabel(String string) {
        this.verticalLabel = string;
    }

    public void setWidth(int n) {
        this.width = n;
    }

    public void setHeight(int n) {
        this.height = n;
    }

    public void setInterlaced(boolean bl) {
        this.interlaced = bl;
    }

    public void setImageInfo(String string) {
        this.imageInfo = string;
    }

    public void setImageFormat(String string) {
        this.imageFormat = string;
    }

    public void setBackgroundImage(String string) {
        this.backgroundImage = string;
    }

    public void setOverlayImage(String string) {
        this.overlayImage = string;
    }

    public void setUnit(String string) {
        this.unit = string;
    }

    public void setLazy(boolean bl) {
        this.lazy = bl;
    }

    public void setMinValue(double d) {
        this.minValue = d;
    }

    public void setMaxValue(double d) {
        this.maxValue = d;
    }

    public void setRigid(boolean bl) {
        this.rigid = bl;
    }

    public void setBase(double d) {
        this.base = d;
    }

    public void setLogarithmic(boolean bl) {
        this.logarithmic = bl;
    }

    public void setColor(int n, Paint paint) throws RrdException {
        if (n < 0 || n >= this.colors.length) {
            throw new RrdException("Invalid color index specified: " + n);
        }
        this.colors[n] = paint;
    }

    public void setColor(String string, Paint paint) throws RrdException {
        this.setColor(RrdGraphDef.getColorTagByName(string), paint);
    }

    private static int getColorTagByName(String string) throws RrdException {
        for (int i = 0; i < COLOR_NAMES.length; ++i) {
            if (!COLOR_NAMES[i].equalsIgnoreCase(string)) continue;
            return i;
        }
        throw new RrdException("Unknown color name specified: " + string);
    }

    public void setNoLegend(boolean bl) {
        this.noLegend = bl;
    }

    public void setOnlyGraph(boolean bl) {
        this.onlyGraph = bl;
    }

    public void setForceRulesLegend(boolean bl) {
        this.forceRulesLegend = bl;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public void setStep(long l) {
        this.step = l;
    }

    public Font getSmallFont() {
        return this.smallFont;
    }

    public Font getLargeFont() {
        return this.largeFont;
    }

    public void setSmallFont(Font font) {
        this.smallFont = font;
    }

    public void setLargeFont(Font font) {
        this.largeFont = font;
    }

    public void datasource(String string, String string2, String string3, String string4) {
        this.sources.add(new Def(string, string2, string3, string4));
    }

    public void datasource(String string, String string2, String string3, String string4, String string5) {
        this.sources.add(new Def(string, string2, string3, string4, string5));
    }

    public void datasource(String string, String string2) {
        this.sources.add(new CDef(string, string2));
    }

    public void datasource(String string, String string2, String string3) {
        this.sources.add(new SDef(string, string2, string3));
    }

    public void datasource(String string, Plottable plottable) {
        this.sources.add(new PDef(string, plottable));
    }

    public void print(String string, String string2, String string3) {
        this.comments.add(new PrintText(string, string2, string3, false));
    }

    public void gprint(String string, String string2, String string3) {
        this.comments.add(new PrintText(string, string2, string3, true));
    }

    public void comment(String string) {
        this.comments.add(new CommentText(string));
    }

    public void hrule(double d, Paint paint, String string) {
        this.hrule(d, paint, string, 1.0f);
    }

    public void hrule(double d, Paint paint, String string, float f) {
        LegendText legendText = new LegendText(paint, string);
        this.comments.add(legendText);
        this.plotElements.add(new HRule(d, paint, legendText, f));
    }

    public void vrule(long l, Paint paint, String string) {
        this.vrule(l, paint, string, 1.0f);
    }

    public void vrule(long l, Paint paint, String string, float f) {
        LegendText legendText = new LegendText(paint, string);
        this.comments.add(legendText);
        this.plotElements.add(new VRule(l, paint, legendText, f));
    }

    public void line(String string, Paint paint, String string2, float f) {
        LegendText legendText = new LegendText(paint, string2);
        this.comments.add(legendText);
        this.plotElements.add(new Line(string, paint, f));
    }

    public void line(String string, Paint paint, String string2) {
        this.line(string, paint, string2, 1.0f);
    }

    public void area(String string, Paint paint, String string2) {
        this.area(string, paint);
        if (string2.length() > 0) {
            LegendText legendText = new LegendText(paint, string2);
            this.comments.add(legendText);
        }
    }

    public void area(String string, Paint paint) {
        this.plotElements.add(new Area(string, paint));
    }

    public void stack(String string, Paint paint, String string2) throws RrdException {
        SourcedPlotElement sourcedPlotElement = null;
        for (int i = this.plotElements.size() - 1; i >= 0; --i) {
            PlotElement plotElement = this.plotElements.get(i);
            if (!(plotElement instanceof SourcedPlotElement)) continue;
            sourcedPlotElement = (SourcedPlotElement)plotElement;
            break;
        }
        if (sourcedPlotElement == null) {
            throw new RrdException("You have to stack graph onto something (line or area)");
        }
        LegendText legendText = new LegendText(paint, string2);
        this.comments.add(legendText);
        this.plotElements.add(new Stack(sourcedPlotElement, string, paint));
    }

    public void setDrawXGrid(boolean bl) {
        this.drawXGrid = bl;
    }

    public void setDrawYGrid(boolean bl) {
        this.drawYGrid = bl;
    }

    public void setImageQuality(float f) {
        this.imageQuality = f;
    }

    public void setAntiAliasing(boolean bl) {
        this.antiAliasing = bl;
    }

    public void setShowSignature(boolean bl) {
        this.showSignature = bl;
    }

    public void setFirstDayOfWeek(int n) {
        this.firstDayOfWeek = n;
    }

    int printStatementCount() {
        int n = 0;
        for (CommentText commentText : this.comments) {
            if (!(commentText instanceof PrintText) || !commentText.isPrint()) continue;
            ++n;
        }
        return n;
    }

    boolean shouldPlot() {
        if (this.plotElements.size() > 0) {
            return true;
        }
        for (CommentText commentText : this.comments) {
            if (!commentText.isValidGraphElement()) continue;
            return true;
        }
        return false;
    }
}

