/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.directory.v2;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import org.apache.commons.lang.StringUtils;
import org.springframework.ldap.filter.AndFilter;
import org.springframework.ldap.filter.EqualsFilter;
import org.springframework.ldap.filter.Filter;
import org.springframework.ldap.filter.LikeFilter;
import org.springframework.ldap.filter.OrFilter;
import org.springframework.ldap.odm.annotations.Attribute;
import org.springframework.ldap.odm.annotations.Entry;
import org.springframework.ldap.odm.annotations.Transient;

public class MappingHelper {
    private MappingHelper() {
    }

    public static AndFilter getBasicFilter(Object odm) {
        Entry entry = odm.getClass().getAnnotation(Entry.class);
        if (entry != null) {
            AndFilter filter = new AndFilter();
            filter.and((Filter)new EqualsFilter("objectclass", entry.objectClasses()[0]));
            return filter;
        }
        return null;
    }

    public static String getLdapFieldName(Object odm, String attribute) {
        if (odm.getClass().isAnnotationPresent(Entry.class)) {
            try {
                Field field = odm.getClass().getDeclaredField(attribute);
                if (field != null) {
                    Attribute attrAnnotation = field.getAnnotation(Attribute.class);
                    if (StringUtils.isNotEmpty((String)attrAnnotation.name())) {
                        return attrAnnotation.name();
                    }
                    return attribute;
                }
                return null;
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
                return null;
            }
            catch (SecurityException e) {
                e.printStackTrace();
                return null;
            }
        }
        return null;
    }

    public static OrFilter generateOrFilter(Object odm) {
        OrFilter or = new OrFilter();
        if (odm.getClass().isAnnotationPresent(Entry.class)) {
            try {
                for (PropertyDescriptor pd : Introspector.getBeanInfo(odm.getClass()).getPropertyDescriptors()) {
                    Object getterResult;
                    String name = pd.getName();
                    if (pd.getReadMethod() == null || "class".equals(name)) continue;
                    Attribute attrAnnotation = odm.getClass().getDeclaredField(name).getAnnotation(Attribute.class);
                    Transient transAnnotation = odm.getClass().getDeclaredField(name).getAnnotation(Transient.class);
                    if (attrAnnotation == null || transAnnotation != null) continue;
                    if (StringUtils.isNotEmpty((String)attrAnnotation.name())) {
                        name = attrAnnotation.name();
                    }
                    if ((getterResult = pd.getReadMethod().invoke(odm, new Object[0])) == null) continue;
                    if (getterResult instanceof Collection) {
                        Collection collection = (Collection)getterResult;
                        for (Object o : collection) {
                            or.or((Filter)new LikeFilter(name, o.toString()));
                        }
                        continue;
                    }
                    or.or((Filter)new LikeFilter(name, getterResult.toString()));
                }
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            catch (IntrospectionException e) {
                e.printStackTrace();
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
        }
        return or;
    }

    public static AndFilter generateAndFilter(Object odm) {
        AndFilter and = new AndFilter();
        if (odm.getClass().isAnnotationPresent(Entry.class)) {
            try {
                for (PropertyDescriptor pd : Introspector.getBeanInfo(odm.getClass()).getPropertyDescriptors()) {
                    Object getterResult;
                    String name = pd.getName();
                    if (pd.getReadMethod() == null || "class".equals(name)) continue;
                    Attribute attrAnnotation = odm.getClass().getDeclaredField(name).getAnnotation(Attribute.class);
                    Transient transAnnotation = odm.getClass().getDeclaredField(name).getAnnotation(Transient.class);
                    if (attrAnnotation == null || transAnnotation != null) continue;
                    if (StringUtils.isNotEmpty((String)attrAnnotation.name())) {
                        name = attrAnnotation.name();
                    }
                    if ((getterResult = pd.getReadMethod().invoke(odm, new Object[0])) == null) continue;
                    if (getterResult instanceof Collection) {
                        Collection collection = (Collection)getterResult;
                        for (Object o : collection) {
                            and.and((Filter)new LikeFilter(name, o.toString()));
                        }
                        continue;
                    }
                    and.and((Filter)new LikeFilter(name, getterResult.toString()));
                }
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            catch (IntrospectionException e) {
                e.printStackTrace();
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
        }
        return and;
    }
}

