/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.directory.v2.model.ext;

import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;

public enum WorkspaceRole {
    OWNER(5, "MasterOwner"),
    ADMIN(4, "Everything"),
    WRITER(3, "ReadWrite"),
    CONTRIBUTOR(2, "Read", "WriteModifyOwnOnly"),
    READER(1, "Read");

    private final String id = StringUtils.lowerCase((String)this.name());
    private final int weight;
    private final String[] permissions;
    private final String key;
    private final ClassLoader classLoader;

    private WorkspaceRole(int weight, String ... permissions) {
        this.weight = weight;
        this.permissions = permissions;
        this.key = "WORKSPACE_ROLE_" + StringUtils.upperCase((String)this.name());
        this.classLoader = ((Object)((Object)this)).getClass().getClassLoader();
    }

    public static WorkspaceRole fromId(String id) {
        WorkspaceRole result = null;
        for (WorkspaceRole value : WorkspaceRole.values()) {
            if (!value.id.equals(id)) continue;
            result = value;
            break;
        }
        return result;
    }

    public static WorkspaceRole fromPermissions(String ... permissions) {
        WorkspaceRole result = null;
        for (WorkspaceRole value : WorkspaceRole.values()) {
            if (result != null && value.weight <= result.weight) continue;
            boolean matches = true;
            for (String permission : value.getPermissions()) {
                if (ArrayUtils.contains((Object[])permissions, (Object)permission)) continue;
                matches = false;
                break;
            }
            if (!matches) continue;
            result = value;
        }
        return result;
    }

    public String getId() {
        return this.id;
    }

    public int getWeight() {
        return this.weight;
    }

    public String[] getPermissions() {
        return this.permissions;
    }

    public String getKey() {
        return this.key;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }
}

