/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.common.logging;

import java.util.LinkedList;
import java.util.List;
import java.util.logging.ConsoleHandler;
import java.util.logging.Filter;
import java.util.logging.Handler;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.jboss.wsf.common.logging.JDKLogHandler;
import org.jboss.wsf.common.logging.JDKLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDKLogRedirector {
    private List<String> namespaces = new LinkedList<String>();

    public void addNamespace(String ns) {
        this.namespaces.add(ns);
    }

    public List<String> getNamespaces() {
        return this.namespaces;
    }

    public void setNamespaces(List<String> namespaces) {
        this.namespaces = namespaces;
    }

    public void start() {
        this.modifyRootLogger();
        this.addNamespaceHandlers();
    }

    private void modifyRootLogger() {
        LogManager logManager = LogManager.getLogManager();
        Logger root = logManager.getLogger("");
        while (root.getParent() != null) {
            root = root.getParent();
        }
        Handler[] handlers = root.getHandlers();
        for (int i = 0; i < handlers.length; ++i) {
            Handler handler = handlers[i];
            if (!(handler instanceof ConsoleHandler)) continue;
            Filter filter = new Filter(){

                public boolean isLoggable(LogRecord record) {
                    String name = record.getLoggerName();
                    for (String ns : JDKLogRedirector.this.namespaces) {
                        if (!name.startsWith(ns)) continue;
                        return false;
                    }
                    return true;
                }
            };
            handler.setFilter(filter);
        }
    }

    private void addNamespaceHandlers() {
        LogManager logManager = LogManager.getLogManager();
        for (String ns : this.namespaces) {
            JDKLogger log = new JDKLogger(ns);
            log.addHandler(new JDKLogHandler());
            logManager.addLogger(log);
        }
    }
}

