/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.server.deployment.jboss;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.jboss.deployment.DeploymentException;
import org.jboss.deployment.DeploymentInfo;
import org.jboss.deployment.SubDeployerSupport;
import org.jboss.mx.loading.RepositoryClassLoader;
import org.jboss.portal.common.net.URLFilter;
import org.jboss.portal.common.net.URLTools;
import org.jboss.portal.server.Server;
import org.jboss.portal.server.deployment.PortalWebApp;
import org.jboss.portal.server.deployment.jboss.Deployment;
import org.jboss.portal.server.deployment.jboss.DeploymentFactory;
import org.jboss.portal.server.deployment.jboss.DeploymentFactoryContext;
import org.jboss.portal.server.deployment.jboss.PortalDeploymentInfo;
import org.jboss.portal.server.deployment.jboss.PortalDeploymentInfoContext;
import org.jboss.portal.server.deployment.jboss.ServerDeployerMBean;
import org.osivia.portal.api.locator.Locator;
import org.osivia.portal.core.theming.IPageHeaderResourceService;

public class ServerDeployer
extends SubDeployerSupport
implements ServerDeployerMBean {
    private final Logger log = Logger.getLogger(ServerDeployer.class);
    private Server portalServer;
    private Map factoryContexts = Collections.synchronizedMap(new HashMap());
    private Map infoContexts = Collections.synchronizedMap(new HashMap());
    IPageHeaderResourceService pageHeaderResourceService;

    IPageHeaderResourceService getPageHeaderResourceService() {
        if (this.pageHeaderResourceService == null) {
            this.pageHeaderResourceService = (IPageHeaderResourceService)Locator.findMBean(IPageHeaderResourceService.class, (String)"osivia:service=PageHeaderResourceService");
        }
        return this.pageHeaderResourceService;
    }

    @Override
    public Set getFactories() {
        return null;
    }

    public boolean accepts(DeploymentInfo di) {
        return false;
    }

    @Override
    public Server getPortalServer() {
        return this.portalServer;
    }

    @Override
    public void setPortalServer(Server portalServer) {
        this.portalServer = portalServer;
    }

    @Override
    public ServerDeployer getDeployer() {
        return this;
    }

    @Override
    public void registerFactory(String name, URLFilter filter, DeploymentFactory factory, URL setupURL) {
        this.log.debug((Object)("Registering factory " + name));
        if (this.factoryContexts.containsKey(name)) {
            throw new IllegalArgumentException("Attempty to register a factory twice " + name);
        }
        DeploymentFactoryContext factoryCtx = new DeploymentFactoryContext(name, filter, factory, setupURL);
        this.factoryContexts.put(name, factoryCtx);
        this.log.debug((Object)("Added factory " + name));
        if (setupURL != null && URLTools.exists((URL)setupURL)) {
            try {
                this.log.debug((Object)("Found valid setup url to deploy provided by factory " + name + " : " + setupURL));
                PortalDeploymentInfo pdi = new PortalDeploymentInfo(setupURL, this.server);
                pdi.deployer = this;
                this.infoContexts.put(pdi.url, new PortalDeploymentInfoContext(pdi));
                this.mainDeployer.deploy((DeploymentInfo)pdi);
            }
            catch (DeploymentException e) {
                this.log.error((Object)("Failed to deploy setup url " + setupURL));
            }
        }
        for (PortalDeploymentInfoContext pdiCtx : new ArrayList(this.infoContexts.values())) {
            try {
                this.log.debug((Object)("Adding factory " + name + " to pdi " + pdiCtx.getInfo().url));
                pdiCtx.add(factoryCtx, true);
            }
            catch (DeploymentException e) {
                this.log.error((Object)("Failed to deploy url " + pdiCtx.getInfo().url));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterFactory(String name) {
        this.log.debug((Object)("Unregistering factory " + name));
        DeploymentFactoryContext factoryCtx = (DeploymentFactoryContext)this.factoryContexts.remove(name);
        if (factoryCtx == null) {
            throw new IllegalArgumentException("Cannot unregister non existing factory " + name);
        }
        for (PortalDeploymentInfoContext pdiCtx : new ArrayList(this.infoContexts.values())) {
            pdiCtx.remove(factoryCtx, true);
        }
        URL setupURL = factoryCtx.getSetupURL();
        if (setupURL != null && URLTools.exists((URL)setupURL)) {
            this.log.debug((Object)("Found valid setup url to undeploy provided by factory " + name + " : " + setupURL));
            if (this.mainDeployer.isDeployed(setupURL)) {
                try {
                    this.mainDeployer.undeploy(setupURL);
                }
                catch (DeploymentException e) {
                    this.log.error((Object)("Failed to un deploy setup url " + setupURL));
                }
                finally {
                    this.infoContexts.remove(setupURL);
                }
            } else {
                this.log.warn((Object)("Unknown setup url by main deployer provided by factory " + name + " : " + setupURL));
            }
        }
        this.log.debug((Object)("Removed factory " + name));
    }

    protected void processNestedDeployments(DeploymentInfo di) throws DeploymentException {
        PortalDeploymentInfoContext pdiCtx = (PortalDeploymentInfoContext)this.infoContexts.get(di.url);
        for (DeploymentFactoryContext factoryCtx : this.factoryContexts.values()) {
            pdiCtx.add(factoryCtx, false);
        }
    }

    @Override
    public DeploymentFactory findFactory(URL url) {
        throw new UnsupportedOperationException();
    }

    public void create(DeploymentInfo di) throws DeploymentException {
        PortalDeploymentInfoContext pdiCtx = (PortalDeploymentInfoContext)this.infoContexts.get(di.url);
        pdiCtx.create();
        super.create(di);
    }

    public void start(DeploymentInfo di) throws DeploymentException {
        PortalDeploymentInfoContext pdiCtx = (PortalDeploymentInfoContext)this.infoContexts.get(di.url);
        pdiCtx.start();
        super.start(di);
    }

    public void stop(DeploymentInfo di) throws DeploymentException {
        PortalDeploymentInfoContext pdiCtx = (PortalDeploymentInfoContext)this.infoContexts.get(di.url);
        pdiCtx.stop();
        super.stop(di);
    }

    public void destroy(DeploymentInfo di) throws DeploymentException {
        PortalDeploymentInfoContext pdiCtx = (PortalDeploymentInfoContext)this.infoContexts.get(di.url);
        pdiCtx.destroy();
        super.destroy(di);
    }

    @Override
    public void deploy(PortalWebApp pwa) throws DeploymentException {
        this.instrument(pwa);
        RepositoryClassLoader rcl = Deployment.findRepositoryClassLoader(pwa.getClassLoader());
        URL url = Deployment.findWEBINFURL(pwa.getURL());
        PortalDeploymentInfo pdi = new PortalDeploymentInfo(url, null, pwa, this.server);
        pdi.ucl = rcl;
        pdi.deployer = this;
        this.infoContexts.put(pdi.url, new PortalDeploymentInfoContext(pdi));
        this.mainDeployer.deploy((DeploymentInfo)pdi);
        this.getPageHeaderResourceService().deploy(pwa);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void undeploy(PortalWebApp pwa) throws DeploymentException {
        URL url = Deployment.findWEBINFURL(pwa.getURL());
        try {
            this.getPageHeaderResourceService().undeploy(pwa);
            this.mainDeployer.undeploy(url);
        }
        catch (Exception e) {
            this.log.error((Object)"Error when undeploying portal web app", (Throwable)e);
        }
        finally {
            this.infoContexts.remove(url);
        }
    }

    private void instrument(PortalWebApp pwa) {
        try {
            pwa.instrument();
        }
        catch (Exception e) {
            this.log.error((Object)"Cannot instrument the web application", (Throwable)e);
        }
    }
}

