/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.taglib.toutatice;

import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.domain.DocumentDTO;
import fr.toutatice.portail.cms.nuxeo.taglib.common.ToutaticeSimpleTag;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.Locale;
import javax.servlet.ServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import org.osivia.portal.api.internationalization.Bundle;
import org.osivia.portal.api.internationalization.IBundleFactory;
import org.osivia.portal.api.internationalization.IInternationalizationService;
import org.osivia.portal.api.locator.Locator;

public class FileSizeTag
extends ToutaticeSimpleTag {
    private static final String[] UNITS = new String[]{"BYTE", "KILOBYTE", "MEGABYTE", "GIGABYTE", "TERABYTE"};
    private static final double UNIT_FACTOR = 1024.0;
    private Long size;
    private final IBundleFactory bundleFactory;

    public FileSizeTag() {
        IInternationalizationService internationalizationService = (IInternationalizationService)Locator.findMBean(IInternationalizationService.class, (String)"osivia:service=InternationalizationService");
        this.bundleFactory = internationalizationService.getBundleFactory(((Object)((Object)this)).getClass().getClassLoader());
    }

    @Override
    protected void doTag(NuxeoController nuxeoController, DocumentDTO document) throws JspException, IOException {
        PageContext pageContext = (PageContext)this.getJspContext();
        ServletRequest request = pageContext.getRequest();
        Locale locale = request.getLocale();
        Bundle bundle = this.bundleFactory.getBundle(locale);
        JspWriter out = pageContext.getOut();
        if (this.size > 0L) {
            int factor = Double.valueOf(Math.log10(this.size.longValue()) / Math.log10(1024.0)).intValue();
            double factorizedSize = (double)this.size.longValue() / Math.pow(1024.0, factor);
            String unit = bundle.getString(UNITS[factor]);
            NumberFormat numberFormat = NumberFormat.getNumberInstance(locale);
            numberFormat.setMaximumFractionDigits(1);
            out.write(numberFormat.format(factorizedSize));
            out.write("&nbsp;");
            out.write(unit);
        } else {
            out.write("0&nbsp;");
            out.write(bundle.getString(UNITS[0]));
        }
    }

    public void setSize(Long size) {
        this.size = size;
    }
}

