/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.ant;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.cfg.Configuration;
import org.jbpm.JbpmConfiguration;
import org.jbpm.JbpmException;

public abstract class AntHelper {
    static final Map configurations = new HashMap();
    static final Map jbpmConfigurations = new HashMap();
    private static final Log log = LogFactory.getLog((Class)AntHelper.class);

    public static Configuration getConfiguration(String hibernateCfgResource, String hibernatePropertiesResource) {
        Object key = AntHelper.getKey(hibernateCfgResource, hibernatePropertiesResource);
        Configuration configuration = (Configuration)configurations.get(key);
        if (configuration == null) {
            log.debug((Object)("creating hibernate configuration from cfg '" + hibernateCfgResource + "' and properties '" + hibernatePropertiesResource + "'"));
            configuration = new Configuration();
            configuration.configure(hibernateCfgResource);
            if (hibernatePropertiesResource != null) {
                try {
                    InputStream propertiesInputStream = AntHelper.class.getClassLoader().getResourceAsStream(hibernatePropertiesResource);
                    log.debug((Object)("properties input stream: " + propertiesInputStream));
                    Properties properties = new Properties();
                    properties.load(propertiesInputStream);
                    configuration.setProperties(properties);
                }
                catch (Exception e) {
                    throw new JbpmException("couldn't set properties '" + hibernatePropertiesResource + "'", e);
                }
            }
            configurations.put(key, configuration);
        } else {
            log.debug((Object)("got hibernate configuration from cfg '" + hibernateCfgResource + "' and properties '" + hibernatePropertiesResource + "' from the cache"));
        }
        return configuration;
    }

    public static JbpmConfiguration getJbpmConfiguration(String jbpmCfg) {
        JbpmConfiguration jbpmConfiguration = (JbpmConfiguration)jbpmConfigurations.get(jbpmCfg);
        if (jbpmConfiguration == null) {
            jbpmConfiguration = jbpmCfg == null ? JbpmConfiguration.getInstance() : JbpmConfiguration.getInstance(jbpmCfg);
            jbpmConfigurations.put(jbpmCfg, jbpmConfiguration);
        }
        return jbpmConfiguration;
    }

    static Object getKey(String cfg, String properties) {
        ArrayList<String> key = new ArrayList<String>();
        key.add(cfg);
        key.add(properties);
        return key;
    }
}

