/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.core.impl.model.content.generic;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jboss.portal.Mode;
import org.jboss.portal.common.i18n.LocalizedString;
import org.jboss.portal.common.util.ParameterMap;
import org.jboss.portal.core.CoreConstants;
import org.jboss.portal.core.impl.model.content.InternalContentProvider;
import org.jboss.portal.core.impl.model.content.generic.GenericContent;
import org.jboss.portal.core.model.content.Content;
import org.jboss.portal.core.model.content.ContentType;
import org.jboss.portal.core.model.content.spi.ContentProvider;
import org.jboss.portal.core.model.content.spi.handler.ContentHandler;
import org.jboss.portal.core.model.content.spi.handler.ContentState;
import org.jboss.portal.core.model.content.spi.portlet.ContentPortlet;
import org.jboss.portal.core.model.instance.Instance;
import org.jboss.portal.core.model.instance.InstanceContainer;
import org.jboss.portal.core.model.portal.Window;
import org.jboss.portal.core.model.portal.command.response.MarkupResponse;
import org.jboss.portal.core.model.portal.content.ContentRendererContext;
import org.jboss.portal.core.model.portal.content.WindowRendition;
import org.jboss.portal.identity.User;
import org.jboss.portal.portlet.ParametersStateString;
import org.jboss.portal.portlet.Portlet;
import org.jboss.portal.portlet.PortletInvokerException;
import org.jboss.portal.portlet.StateString;
import org.jboss.portal.portlet.controller.state.PortletWindowNavigationalState;
import org.jboss.portal.portlet.info.NavigationInfo;
import org.jboss.portal.portlet.info.ParameterInfo;
import org.jboss.portal.portlet.info.PortletInfo;
import org.jboss.portal.portlet.invocation.RenderInvocation;

public class InternalGenericContentProvider
extends InternalContentProvider
implements ContentHandler {
    private static final Logger log = Logger.getLogger(InternalGenericContentProvider.class);
    protected InstanceContainer instanceContainer;
    protected boolean decorateContent;
    protected ContentPortlet contentPortlet;

    public InstanceContainer getInstanceContainer() {
        return this.instanceContainer;
    }

    public void setInstanceContainer(InstanceContainer instanceContainer) {
        this.instanceContainer = instanceContainer;
    }

    public ContentPortlet getContentPortletInfo() {
        return this.contentPortlet;
    }

    public void setContentPortletInfo(ContentPortlet contentPortlet) {
        this.contentPortlet = contentPortlet;
    }

    public boolean getDecorateContent() {
        return this.decorateContent;
    }

    public void setDecorateContent(boolean decorateContent) {
        this.decorateContent = decorateContent;
    }

    protected ContentProvider createProvider() {
        return new ContentProvider(){

            public ContentType getContentType() {
                return InternalGenericContentProvider.this.getRegisteredContentType();
            }

            public LocalizedString getDisplayName() {
                return null;
            }

            public LocalizedString getDescription() {
                return null;
            }

            public ContentHandler getHandler() {
                return InternalGenericContentProvider.this;
            }

            public ContentPortlet getPortletInfo() {
                return InternalGenericContentProvider.this.contentPortlet;
            }
        };
    }

    public Content newContent(String contextId, ContentState state) {
        return new GenericContent(state);
    }

    protected Instance getPortletInstance(ContentRendererContext rendererContext) {
        String id = this.contentPortlet.getPortletName(Mode.VIEW);
        if (id != null) {
            return this.instanceContainer.getDefinition(id);
        }
        return null;
    }

    public void contentCreated(String contextId, ContentState state) {
    }

    public void contentDestroyed(String contextId, ContentState state) {
    }

    public WindowRendition renderWindow(final ContentRendererContext rendererContext) {
        Window window = rendererContext.getWindow();
        final Content content = window.getContent();
        if (content == null) {
            return null;
        }
        ContentRendererContext rendererContext2 = new ContentRendererContext(){

            public Window getWindow() {
                return rendererContext.getWindow();
            }

            public PortletWindowNavigationalState getPortletNavigationalState() {
                return rendererContext.getPortletNavigationalState();
            }

            public User getUser() {
                return rendererContext.getUser();
            }

            public RenderInvocation createRenderInvocation(PortletWindowNavigationalState navigationalState) {
                RenderInvocation invocation = rendererContext.createRenderInvocation(navigationalState);
                if (invocation.getPublicNavigationalState() == null || invocation.getPublicNavigationalState().size() == 0) {
                    String id_uri = null;
                    String id_parameters = null;
                    try {
                        Instance instance = InternalGenericContentProvider.this.getPortletInstance(rendererContext);
                        Portlet portlet = instance.getPortlet();
                        PortletInfo portletInfo = portlet.getInfo();
                        NavigationInfo navigationInfo = portletInfo.getNavigation();
                        ParameterInfo parameterInfo = navigationInfo.getPublicParameter(CoreConstants.JBOSS_PORTAL_CONTENT_URI);
                        if (parameterInfo != null) {
                            id_uri = parameterInfo.getId();
                        }
                        if ((parameterInfo = navigationInfo.getPublicParameter(CoreConstants.JBOSS_PORTAL_CONTENT_PARAMETERS)) != null) {
                            id_parameters = parameterInfo.getId();
                        }
                    }
                    catch (PortletInvokerException e) {
                        log.error((Object)"Cannot read portlet instance public navigational info", (Throwable)e);
                    }
                    ParameterMap parameterMap = new ParameterMap();
                    if (id_uri != null) {
                        parameterMap.put(id_uri, (Object)new String[]{content.getURI()});
                    }
                    if (id_parameters != null) {
                        ArrayList<String> paramNames = new ArrayList<String>();
                        Iterator<String> params = content.getParameterNames();
                        ParameterMap parameterMap2 = new ParameterMap();
                        while (params.hasNext()) {
                            String name = params.next();
                            String value = content.getParameter(name);
                            parameterMap2.put((Object)(id_parameters + "." + name), (Object)new String[]{value});
                            paramNames.add(name);
                        }
                        invocation.setNavigationalState((StateString)ParametersStateString.create((Map)parameterMap2));
                        if (paramNames.size() != 0) {
                            parameterMap.put((Object)id_parameters, (Object)paramNames.toArray(new String[paramNames.size()]));
                        }
                    }
                    invocation.setPublicNavigationalState((Map)parameterMap);
                }
                return invocation;
            }
        };
        WindowRendition rendition = super.renderWindow(rendererContext2);
        if (rendition != null && rendition.getControllerResponse() instanceof MarkupResponse && !this.getDecorateContent()) {
            Map<String, String> props = rendition.getProperties();
            if (props.get("theme.windowRendererId") == null) {
                props.put("theme.windowRendererId", "emptyRenderer");
            }
            if (props.get("theme.decorationRendererId") == null) {
                props.put("theme.decorationRendererId", "emptyRenderer");
            }
            if (props.get("theme.portletRendererId") == null) {
                props.put("theme.portletRendererId", "emptyRenderer");
            }
        }
        return rendition;
    }
}

