/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.core.impl.model.portal;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.jboss.portal.core.impl.model.portal.PageImpl;
import org.jboss.portal.core.impl.model.portal.PortalObjectImpl;
import org.jboss.portal.core.model.portal.DuplicatePortalObjectException;
import org.jboss.portal.core.model.portal.Page;
import org.jboss.portal.core.model.portal.Portal;
import org.jboss.portal.core.model.portal.PortalObject;

public class PortalImpl
extends PortalObjectImpl
implements Portal {
    protected Set windowStates;
    protected Set modes;

    public PortalImpl() {
        this(true);
    }

    public PortalImpl(boolean hibernate) {
        super(hibernate);
        this.windowStates = hibernate ? null : new HashSet();
        this.modes = hibernate ? null : new HashSet();
    }

    public Set getModes() {
        return this.modes;
    }

    public void setModes(Set modes) {
        this.modes = modes;
    }

    public Set getWindowStates() {
        return this.windowStates;
    }

    public void setWindowStates(Set windowStates) {
        this.windowStates = windowStates;
    }

    public Set getSupportedWindowStates() {
        return this.windowStates;
    }

    public Set getSupportedModes() {
        return this.modes;
    }

    public Page getPage(String name) {
        PortalObject child = this.getChild(name);
        if (child instanceof Page) {
            return (Page)child;
        }
        return null;
    }

    public Page createPage(String name) throws DuplicatePortalObjectException {
        PageImpl page = new PageImpl(false);
        this.addChild(name, page);
        return page;
    }

    public int getType() {
        return 1;
    }

    public Page getDefaultPage() {
        PortalObject child = this.getDefaultChild();
        if (child instanceof Page) {
            return (Page)child;
        }
        if (child != null) {
            log.warn((Object)("Default child is not a page " + child));
        }
        return null;
    }

    protected PortalObjectImpl cloneObject() {
        PortalImpl clone = new PortalImpl();
        clone.setWindowStates(new HashSet(this.getWindowStates()));
        clone.setModes(new HashSet(this.getModes()));
        clone.setDeclaredPropertyMap(new HashMap<String, String>(this.getDeclaredPropertyMap()));
        clone.setListener(this.getListener());
        clone.setDisplayName(this.getDisplayName());
        return clone;
    }
}

